/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.proxy;

import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.felix.http.proxy.impl.EventDispatcherTracker;
import org.osgi.framework.BundleContext;

public abstract class AbstractProxyListener
implements HttpSessionListener,
HttpSessionIdListener,
HttpSessionAttributeListener,
ServletContextAttributeListener {
    private static final String ATTR_BUNDLE_CONTEXT = BundleContext.class.getName();

    public void sessionCreated(HttpSessionEvent se) {
        HttpSessionListener sessionDispatcher = this.getSessionDispatcher();
        if (sessionDispatcher != null) {
            sessionDispatcher.sessionCreated(se);
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSessionListener sessionDispatcher = this.getSessionDispatcher();
        if (sessionDispatcher != null) {
            sessionDispatcher.sessionDestroyed(se);
        }
    }

    public void sessionIdChanged(HttpSessionEvent event, String oldSessionId) {
        HttpSessionIdListener sessionIdDispatcher = this.getSessionIdDispatcher();
        if (sessionIdDispatcher != null) {
            sessionIdDispatcher.sessionIdChanged(event, oldSessionId);
        }
    }

    public void attributeAdded(HttpSessionBindingEvent se) {
        HttpSessionAttributeListener attributeDispatcher = this.getAttributeDispatcher();
        if (attributeDispatcher != null) {
            attributeDispatcher.attributeAdded(se);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent se) {
        HttpSessionAttributeListener attributeDispatcher = this.getAttributeDispatcher();
        if (attributeDispatcher != null) {
            attributeDispatcher.attributeRemoved(se);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent se) {
        HttpSessionAttributeListener attributeDispatcher = this.getAttributeDispatcher();
        if (attributeDispatcher != null) {
            attributeDispatcher.attributeReplaced(se);
        }
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
        if (event.getName().equals(ATTR_BUNDLE_CONTEXT)) {
            this.startTracking(event.getValue());
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        if (event.getName().equals(ATTR_BUNDLE_CONTEXT)) {
            this.stopTracking();
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        if (event.getName().equals(ATTR_BUNDLE_CONTEXT)) {
            this.stopTracking();
            this.startTracking(event.getServletContext().getAttribute(event.getName()));
        }
    }

    protected abstract EventDispatcherTracker getEventDispatcherTracker();

    protected abstract void stopTracking();

    protected abstract void startTracking(Object var1);

    private HttpSessionListener getSessionDispatcher() {
        EventDispatcherTracker eventDispatcherTracker = this.getEventDispatcherTracker();
        if (eventDispatcherTracker != null) {
            return eventDispatcherTracker.getHttpSessionListener();
        }
        return null;
    }

    private HttpSessionIdListener getSessionIdDispatcher() {
        EventDispatcherTracker eventDispatcherTracker = this.getEventDispatcherTracker();
        if (eventDispatcherTracker != null) {
            return eventDispatcherTracker.getHttpSessionIdListener();
        }
        return null;
    }

    private HttpSessionAttributeListener getAttributeDispatcher() {
        EventDispatcherTracker eventDispatcherTracker = this.getEventDispatcherTracker();
        if (eventDispatcherTracker != null) {
            return eventDispatcherTracker.getHttpSessionAttributeListener();
        }
        return null;
    }
}

