/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.command;

import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.ProfileBuilder;
import org.apache.karaf.profile.ProfileService;
import org.apache.karaf.profile.command.completers.ProfileCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(name="rename", scope="profile", description="Rename the specified source profile")
@Service
public class ProfileRename
implements Action {
    @Option(name="--version", description="The profile version to rename. Defaults to the current default version.")
    private String versionId;
    @Option(name="-f", aliases={"--force"}, description="Flag to allow replacing the target profile (if exists).")
    private boolean force;
    @Argument(index=0, required=true, name="profile name", description="Name of the profile.")
    @Completion(value=ProfileCompleter.class)
    private String profileName;
    @Argument(index=1, required=true, name="new profile name", description="New name of the profile.")
    private String newName;
    @Reference
    private ProfileService profileService;

    public Object execute() throws Exception {
        Profile profile = ProfileBuilder.Factory.createFrom(this.profileService.getProfile(this.profileName)).identity(this.newName).getProfile();
        this.profileService.createProfile(profile);
        this.profileService.deleteProfile(this.profileName);
        return null;
    }
}

