/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.ProfileService;
import org.apache.karaf.profile.command.completers.ProfileCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(name="display", scope="profile", description="Displays information about the specified profile")
@Service
public class ProfileDisplay
implements Action {
    @Option(name="--overlay", aliases={"-o"}, description="Shows the overlay profile settings, taking into account the settings inherited from parent profiles.")
    private Boolean overlay = false;
    @Option(name="--effective", aliases={"-e"}, description="Shows the effective profile settings, taking into account properties substitution.")
    private Boolean effective = false;
    @Option(name="--display-resources", aliases={"-r"}, description="Displays the content of additional profile resources.")
    private Boolean displayResources = false;
    @Argument(index=0, required=true, name="profile", description="The name of the profile.")
    @Completion(value=ProfileCompleter.class)
    private String profileId;
    @Reference
    private ProfileService profileService;

    public Object execute() {
        this.displayProfile(this.profileService.getRequiredProfile(this.profileId));
        return null;
    }

    private static void printConfigList(String header, PrintStream out, List<String> list) {
        out.println(header);
        for (String str : list) {
            out.printf("\t%s\n", str);
        }
        out.println();
    }

    /*
     * WARNING - void declaration
     */
    private void displayProfile(Profile profile) {
        PrintStream output = System.out;
        output.println("Profile id: " + profile.getId());
        output.println("Attributes: ");
        Map<String, String> props = profile.getAttributes();
        for (String key : props.keySet()) {
            output.println("\t" + key + ": " + props.get(key));
        }
        if (this.overlay.booleanValue()) {
            profile = this.profileService.getOverlayProfile(profile);
        }
        if (this.effective.booleanValue()) {
            profile = this.profileService.getEffectiveProfile(profile);
        }
        HashMap<String, Map<String, Object>> configuration = new HashMap<String, Map<String, Object>>(profile.getConfigurations());
        Map<String, byte[]> resources = profile.getFileConfigurations();
        Map<String, Object> profileConfiguration = profile.getConfiguration("profile");
        ArrayList<String> profileProperties = new ArrayList<String>();
        ArrayList<String> systemProperties = new ArrayList<String>();
        ArrayList<String> configProperties = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : profileConfiguration.entrySet()) {
            void var13_17;
            String key = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof String && ((String)object).contains(",")) {
                String string = "\t" + ((String)object).replace(",", ",\n\t\t");
            }
            if (key.startsWith("system.")) {
                systemProperties.add("  " + key.substring("system.".length()) + " = " + var13_17);
                continue;
            }
            if (key.startsWith("config.")) {
                configProperties.add("  " + key.substring("config.".length()) + " = " + var13_17);
                continue;
            }
            if (key.startsWith("feature.") || key.startsWith("repository") || key.startsWith("bundle.") || key.startsWith("fab.") || key.startsWith("override.") || key.startsWith("attribute.")) continue;
            profileProperties.add("  " + (String)key + " = " + var13_17);
        }
        if (configuration.containsKey("profile")) {
            output.println("\nContainer settings");
            output.println("----------------------------");
            if (profile.getLibraries().size() > 0) {
                ProfileDisplay.printConfigList("Libraries : ", output, profile.getLibraries());
            }
            if (profile.getRepositories().size() > 0) {
                ProfileDisplay.printConfigList("Repositories : ", output, profile.getRepositories());
            }
            if (profile.getFeatures().size() > 0) {
                ProfileDisplay.printConfigList("Features : ", output, profile.getFeatures());
            }
            if (profile.getBundles().size() > 0) {
                ProfileDisplay.printConfigList("Bundles : ", output, profile.getBundles());
            }
            if (profile.getOverrides().size() > 0) {
                ProfileDisplay.printConfigList("Overrides : ", output, profile.getOverrides());
            }
            if (profileProperties.size() > 0) {
                ProfileDisplay.printConfigList("Profile Properties : ", output, profileProperties);
            }
            if (systemProperties.size() > 0) {
                ProfileDisplay.printConfigList("System Properties : ", output, systemProperties);
            }
            if (configProperties.size() > 0) {
                ProfileDisplay.printConfigList("Config Properties : ", output, configProperties);
            }
            configuration.remove("profile");
        }
        output.println("\nConfiguration details");
        output.println("----------------------------");
        for (Map.Entry<String, Object> entry : configuration.entrySet()) {
            output.println("PID: " + entry.getKey());
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                output.println("  " + (String)entry2.getKey() + " " + entry2.getValue());
            }
            output.println("\n");
        }
        output.println("\nOther resources");
        output.println("----------------------------");
        for (Map.Entry<String, Object> entry : resources.entrySet()) {
            String name = entry.getKey();
            if (name.endsWith(".properties")) continue;
            output.println("Resource: " + entry.getKey());
            if (!this.displayResources.booleanValue()) continue;
            output.println(new String((byte[])entry.getValue()));
            output.println("\n");
        }
    }
}

