/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.shell;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.pkts.Pcap;
import io.pkts.packet.UDPPacket;
import io.pkts.protocol.Protocol;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.telemetry.api.TelemetryManager;
import org.opennms.netmgt.telemetry.api.receiver.Listener;
import org.opennms.netmgt.telemetry.api.receiver.Parser;
import org.opennms.netmgt.telemetry.listeners.UdpParser;
import org.opennms.netmgt.telemetry.shell.Parsers;

@Command(scope="opennms", name="telemetry-replay-pcap", description="Replay a packet capture directly to a UDP-based parser.")
@Service
public class ReplayPcap
implements Action {
    @Reference
    public TelemetryManager manager;
    @Argument(index=0, name="listener", description="Listener name", required=true)
    @Completion(value=Parsers.ListenerCompleter.class)
    public String listenerName;
    @Argument(index=1, name="parser", description="Parser name", required=true)
    public String parserName;
    @Argument(index=2, name="pcap", description="Path to .pcap file for replay", required=true)
    public File pcapFile;
    @Option(name="-c", aliases={"--counter"}, description="Display packet counter every n-th packet. Set to <= 0 to disable.")
    public int packetCounterFrequency = 100;

    public Object execute() throws Exception {
        Listener listener = this.manager.getListeners().stream().filter(l -> Objects.equals(l.getName(), this.listenerName)).min(Comparator.comparing(Listener::getName)).orElseThrow(() -> new RuntimeException(String.format("No listener with name '%s' found.", this.listenerName)));
        Parser parser = listener.getParsers().stream().filter(p -> Objects.equals(p.getName(), this.parserName)).min(Comparator.comparing(Parser::getName)).orElseThrow(() -> new RuntimeException(String.format("No parser with name '%s' found.", this.parserName)));
        if (!(parser instanceof UdpParser)) {
            throw new RuntimeException("Parser must implement UdpParser interface to be used to .pcap replay.");
        }
        UdpParser udpParser = (UdpParser)parser;
        try (FileInputStream in = new FileInputStream(this.pcapFile);){
            System.out.printf("Processing packets from '%s'.%n", this.pcapFile);
            AtomicLong packetCount = new AtomicLong();
            Pcap pcap = Pcap.openStream((InputStream)in);
            pcap.loop(packet -> {
                if (packet.hasProtocol(Protocol.UDP)) {
                    packetCount.getAndIncrement();
                    if (this.packetCounterFrequency > 0 && packetCount.get() % (long)this.packetCounterFrequency == 0L) {
                        System.out.printf("Processing packet #%d.%n", packetCount.get());
                    }
                    UDPPacket udp = (UDPPacket)packet.getPacket(Protocol.UDP);
                    InetSocketAddress remoteAddress = new InetSocketAddress(InetAddressUtils.getInetAddress((String)udp.getParentPacket().getSourceIP()), udp.getSourcePort());
                    InetSocketAddress localAddress = new InetSocketAddress(InetAddressUtils.getInetAddress((String)udp.getParentPacket().getDestinationIP()), udp.getDestinationPort());
                    ByteBuf buffer = Unpooled.wrappedBuffer((byte[])udp.getPayload().getArray());
                    try {
                        udpParser.parse(buffer, remoteAddress, localAddress);
                    }
                    catch (Exception e) {
                        System.err.printf("Failed to parse packet %s->%s@%s: %s", remoteAddress, localAddress, udp.getArrivalTime(), e.getMessage());
                    }
                }
                return true;
            });
            System.out.printf("Done processing %d packets.%n", packetCount.get());
        }
        return null;
    }
}

