/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tasks;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.tasks.AbstractTask;
import org.opennms.core.tasks.Async;
import org.opennms.core.tasks.AsyncTask;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.Callback;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.SequenceTask;
import org.opennms.core.tasks.SyncTask;
import org.opennms.core.tasks.TaskBuilder;
import org.opennms.core.tasks.TaskCoordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultTaskCoordinator
implements TaskCoordinator,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTaskCoordinator.class);
    private final Executor m_actorExecutor;
    private final ConcurrentHashMap<String, Executor> m_taskExecutors = new ConcurrentHashMap();
    private String m_defaultExecutorName = "default";
    private long m_loopDelay = 0L;

    public DefaultTaskCoordinator(String name) {
        this.m_actorExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new LogPreservingThreadFactory(name + "-TaskScheduler", 1));
        this.addOrUpdateExecutor(this.m_defaultExecutorName, Executors.newSingleThreadExecutor((ThreadFactory)new LogPreservingThreadFactory(this.m_defaultExecutorName, 1)));
    }

    public final void setDefaultExecutor(String executorName) {
        this.m_defaultExecutorName = executorName;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_defaultExecutorName, (String)"defaultExecutor must be set");
        Assert.notNull((Object)this.getExecutor(this.m_defaultExecutorName), (String)"defaultExecutor must be set to the name of an added executor");
    }

    @Override
    public SyncTask createTask(ContainerTask<?> parent, Runnable r) {
        return new SyncTask(this, parent, r);
    }

    @Override
    public SyncTask createTask(ContainerTask<?> parent, Runnable r, String schedulingHint) {
        return new SyncTask(this, parent, r, schedulingHint);
    }

    @Override
    public <T> AsyncTask<T> createTask(ContainerTask<?> parent, Async<T> async, Callback<T> cb) {
        return new AsyncTask<T>(this, parent, async, cb);
    }

    @Override
    public TaskBuilder<BatchTask> createBatch(ContainerTask<?> parent) {
        return new TaskBuilder<BatchTask>(new BatchTask(this, parent));
    }

    @Override
    public TaskBuilder<BatchTask> createBatch() {
        return this.createBatch((ContainerTask)null);
    }

    @Override
    public BatchTask createBatch(ContainerTask<?> parent, Runnable ... tasks) {
        return this.createBatch(parent).add(tasks).get(parent);
    }

    @Override
    public BatchTask createBatch(Runnable ... tasks) {
        return this.createBatch().add(tasks).get();
    }

    @Override
    public TaskBuilder<SequenceTask> createSequence(ContainerTask<?> parent) {
        return new TaskBuilder<SequenceTask>(new SequenceTask(this, parent));
    }

    @Override
    public TaskBuilder<SequenceTask> createSequence() {
        return this.createSequence(null);
    }

    @Override
    public SequenceTask createSequence(ContainerTask<?> parent, Runnable ... tasks) {
        return this.createSequence(parent).add(tasks).get(parent);
    }

    @Override
    public final void setLoopDelay(long millis) {
        this.m_loopDelay = millis;
    }

    @Override
    public void schedule(AbstractTask task) {
        this.onProcessorThread(DefaultTaskCoordinator.scheduler(task));
    }

    @Override
    public void addDependency(AbstractTask prereq, AbstractTask dependent) {
        dependent.incrPendingPrereqCount();
        this.onProcessorThread(DefaultTaskCoordinator.dependencyAdder(prereq, dependent));
    }

    void onProcessorThread(final SerialRunnable r) {
        CompletableFuture<Void> future = null;
        future = this.m_loopDelay > 0L ? CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                r.run();
                try {
                    Thread.sleep(DefaultTaskCoordinator.this.m_loopDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, this.m_actorExecutor) : CompletableFuture.runAsync(r, this.m_actorExecutor);
        future.exceptionally(e -> {
            LOG.warn("Unexpected exception during actor runnable: " + e.getMessage(), e);
            return null;
        });
    }

    private static SerialRunnable scheduler(final AbstractTask task) {
        return new SerialRunnable(){

            @Override
            public void run() {
                task.scheduled();
                task.submitIfReady();
            }

            public String toString() {
                return String.format("schedule(%s)", task);
            }
        };
    }

    private static SerialRunnable taskCompleter(final AbstractTask task) {
        return new SerialRunnable(){

            @Override
            public void run() {
                DefaultTaskCoordinator.notifyDependents(task);
            }

            public String toString() {
                return String.format("notifyDependents(%s)", task);
            }
        };
    }

    private static void notifyDependents(AbstractTask task) {
        task.onComplete();
        Set<AbstractTask> dependents = task.getDependents();
        for (AbstractTask dependent : dependents) {
            dependent.doCompletePrerequisite(task);
            dependent.submitIfReady();
        }
        task.clearDependents();
    }

    private static SerialRunnable dependencyAdder(final AbstractTask prereq, final AbstractTask dependent) {
        Assert.notNull((Object)prereq, (String)"prereq must not be null");
        Assert.notNull((Object)dependent, (String)"dependent must not be null");
        return new SerialRunnable(){

            @Override
            public void run() {
                prereq.doAddDependent(dependent);
                dependent.doAddPrerequisite(prereq);
                dependent.decrPendingPrereqCount();
                dependent.submitIfReady();
            }

            public String toString() {
                return String.format("%s.addPrerequisite(%s)", dependent, prereq);
            }
        };
    }

    public final Executor getExecutor(String name) {
        Executor executor = this.m_taskExecutors.get(name);
        if (executor == null) {
            Executor defaultExecutor = this.m_taskExecutors.get(this.m_defaultExecutorName);
            if (defaultExecutor == null) {
                throw new IllegalStateException("No default executor in " + this.getClass().getName());
            }
            return defaultExecutor;
        }
        return executor;
    }

    @Override
    public void markTaskAsCompleted(AbstractTask task) {
        this.onProcessorThread(DefaultTaskCoordinator.taskCompleter(task));
    }

    @Override
    public void submitToExecutor(String executorPreference, Runnable workToBeDone, AbstractTask owningTask) {
        ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(workToBeDone, this.getExecutor(executorPreference)).exceptionally(e -> {
            LOG.warn("Unexpected exception during task execution: " + e.getMessage(), e);
            return null;
        })).thenRunAsync(DefaultTaskCoordinator.taskCompleter(owningTask), this.m_actorExecutor)).exceptionally(e -> {
            LOG.warn("Unexpected exception during task completion: " + e.getMessage(), e);
            return null;
        });
    }

    @Override
    public final void addOrUpdateExecutor(String executorName, Executor executor) {
        Executor service = this.m_taskExecutors.put(executorName, executor);
        if (service != null) {
            LOG.info("Replacing executor {} with {}", (Object)executorName, (Object)executor);
        }
    }

    @Override
    public final void setExecutors(Map<String, Executor> executors) {
        this.m_taskExecutors.clear();
        for (Map.Entry<String, Executor> e : executors.entrySet()) {
            this.addOrUpdateExecutor(e.getKey(), e.getValue());
        }
    }

    static interface SerialRunnable
    extends Runnable {
    }
}

