/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tasks;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.opennms.core.tasks.ContainerTask;
import org.opennms.core.tasks.DefaultTaskMonitor;
import org.opennms.core.tasks.Task;
import org.opennms.core.tasks.TaskCoordinator;
import org.opennms.core.tasks.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTask
implements Task {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTask.class);
    private final TaskCoordinator m_coordinator;
    private final AtomicReference<Task.State> m_state = new AtomicReference<Task.State>(Task.State.NEW);
    private final AtomicBoolean m_scheduleCalled = new AtomicBoolean(false);
    private final CountDownLatch m_latch = new CountDownLatch(1);
    private final AtomicInteger m_pendingPrereqs = new AtomicInteger(0);
    private final Set<AbstractTask> m_dependents = new CopyOnWriteArraySet<AbstractTask>();
    private final Set<AbstractTask> m_prerequisites = new CopyOnWriteArraySet<AbstractTask>();
    private final TaskMonitor m_monitor;

    public AbstractTask(TaskCoordinator coordinator, ContainerTask<?> parent) {
        this.m_coordinator = coordinator;
        this.m_monitor = parent != null ? parent.getMonitor().getChildTaskMonitor(parent, this) : new DefaultTaskMonitor(this);
    }

    @Override
    public final TaskCoordinator getCoordinator() {
        return this.m_coordinator;
    }

    @Override
    public final TaskMonitor getMonitor() {
        return this.m_monitor;
    }

    final Set<AbstractTask> getDependents() {
        return this.m_dependents;
    }

    final void doAddDependent(AbstractTask dependent) {
        if (!this.isFinished()) {
            this.m_dependents.add(dependent);
        }
    }

    final void doAddPrerequisite(AbstractTask prereq) {
        if (!prereq.isFinished()) {
            this.m_prerequisites.add(prereq);
            this.notifyPrerequisiteAdded(prereq);
        }
    }

    private final void notifyPrerequisiteAdded(AbstractTask prereq) {
        try {
            this.m_monitor.prerequisiteAdded(this, prereq);
        }
        catch (Throwable t) {
            this.m_monitor.monitorException(t);
        }
    }

    private final void notifyPrerequisiteCompleted(AbstractTask prereq) {
        try {
            this.m_monitor.prerequisiteCompleted(this, prereq);
        }
        catch (Throwable t) {
            this.m_monitor.monitorException(t);
        }
    }

    private final void notifyScheduled() {
        try {
            this.m_monitor.scheduled(this);
        }
        catch (Throwable t) {
            this.m_monitor.monitorException(t);
        }
    }

    private final void notifySubmitted() {
        try {
            this.m_monitor.submitted(this);
        }
        catch (Throwable t) {
            this.m_monitor.monitorException(t);
        }
    }

    private final void notifyCompleted() {
        try {
            this.m_monitor.completed(this);
        }
        catch (Throwable t) {
            this.m_monitor.monitorException(t);
        }
    }

    final void doCompletePrerequisite(AbstractTask prereq) {
        this.m_prerequisites.remove(prereq);
        this.notifyPrerequisiteCompleted(prereq);
    }

    final void clearDependents() {
        this.m_dependents.clear();
    }

    final void scheduled() {
        this.setState(Task.State.NEW, Task.State.SCHEDULED);
        this.notifyScheduled();
    }

    private final void setState(Task.State oldState, Task.State newState) {
        if (!this.m_state.compareAndSet(oldState, newState)) {
            LOG.debug("Attempted to move to state {} with state not {} (actual value {})", new Object[]{newState, oldState, this.m_state.get()});
        } else {
            LOG.trace("Set state to {}", (Object)newState);
        }
    }

    final void submitIfReady() {
        if (this.isReady()) {
            try {
                this.doSubmit();
            }
            catch (Throwable e) {
                LOG.error("Unexpected throwable while trying to submit task: " + this, e);
            }
            finally {
                this.submitted();
                this.completeSubmit();
            }
        }
    }

    protected void doSubmit() {
    }

    private final void submitted() {
        this.setState(Task.State.SCHEDULED, Task.State.SUBMITTED);
        this.notifySubmitted();
    }

    protected void completeSubmit() {
    }

    private final void completed() {
        this.m_state.compareAndSet(Task.State.SUBMITTED, Task.State.COMPLETED);
        this.notifyCompleted();
    }

    final boolean isReady() {
        return this.isInReadyState() && this.m_prerequisites.isEmpty() && this.getPendingPrereqCount() == 0;
    }

    private final int getPendingPrereqCount() {
        return this.m_pendingPrereqs.get();
    }

    private final boolean isInReadyState() {
        return this.m_state.get() == Task.State.SCHEDULED;
    }

    final void incrPendingPrereqCount() {
        this.m_pendingPrereqs.incrementAndGet();
    }

    final void decrPendingPrereqCount() {
        this.m_pendingPrereqs.decrementAndGet();
    }

    final void onComplete() {
        this.completed();
        this.m_latch.countDown();
    }

    @Override
    public final void schedule() {
        this.m_scheduleCalled.set(true);
        try {
            this.preSchedule();
        }
        catch (Throwable e) {
            LOG.error("preSchedule() failed for task " + this, e);
        }
        this.getCoordinator().schedule(this);
        try {
            this.postSchedule();
        }
        catch (Throwable e) {
            LOG.error("postSchedule() failed for task " + this, e);
        }
    }

    protected void preSchedule() {
    }

    protected void postSchedule() {
    }

    final boolean isFinished() {
        return this.m_state.get() == Task.State.COMPLETED;
    }

    protected final boolean isScheduled() {
        return this.m_state.get() != Task.State.NEW || this.m_scheduleCalled.get();
    }

    protected void addPrerequisite(AbstractTask prereq) {
        this.getCoordinator().addDependency(prereq, this);
    }

    protected final void addDependent(AbstractTask dependent) {
        this.getCoordinator().addDependency(this, dependent);
    }

    @Override
    public final void waitFor() throws InterruptedException, ExecutionException {
        this.m_latch.await();
    }

    @Override
    public final boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        return this.m_latch.await(timeout, unit);
    }

    public String toString() {
        return String.format("Task[%s]", super.toString());
    }
}

