/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.IOException;
import java.util.stream.Collectors;
import org.opennms.core.ipc.twin.api.TwinPublisher;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.core.mate.api.SecureCredentialsVaultScope;
import org.opennms.core.spring.BeanUtils;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.netmgt.config.TrapdConfig;
import org.opennms.netmgt.config.TrapdConfigFactory;
import org.opennms.netmgt.config.trapd.Snmpv3User;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.daemon.DaemonTools;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.opennms.netmgt.snmp.TrapListenerConfig;
import org.opennms.netmgt.trapd.TrapListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@EventListener(name="trapd", logPrefix="trapd")
public class Trapd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Trapd.class);
    public static final String LOG4J_CATEGORY = "trapd";
    private int m_status = 0;
    @Autowired
    private TrapListener m_trapListener;
    @Autowired
    private SecureCredentialsVault secureCredentialsVault;
    private TrapdConfig m_config = TrapdConfigFactory.getInstance();
    @Autowired
    private TwinPublisher m_twinPublisher;
    private TwinPublisher.Session<TrapListenerConfig> m_twinSession;

    public Trapd() {
        super(LOG4J_CATEGORY);
    }

    public void setSecureCredentialsVault(SecureCredentialsVault secureCredentialsVault) {
        this.secureCredentialsVault = secureCredentialsVault;
    }

    protected synchronized void onInit() {
        BeanUtils.assertAutowiring((Object)((Object)this));
    }

    protected synchronized void onStart() {
        this.m_status = 1;
        LOG.debug("start: Initializing the Trapd receiver");
        try {
            this.m_twinSession = this.m_twinPublisher.register("trapd.listener.config", TrapListenerConfig.class, null);
        }
        catch (IOException e) {
            LOG.error("Failed to register twin for trap listener config", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            this.m_twinSession.publish((Object)this.from(this.m_config));
        }
        catch (IOException e) {
            LOG.error("Failed to register twin for trap listener config", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.m_trapListener.start();
        this.m_status = 2;
        LOG.debug("start: Trapd is ready to receive traps");
    }

    protected void onPause() {
        if (this.m_status != 2) {
            return;
        }
        this.m_status = 5;
        LOG.debug("pause: Calling pause on trap receiver");
        this.m_trapListener.stop();
        this.m_status = 6;
        LOG.debug("pause: Trapd paused");
    }

    protected void onResume() {
        if (this.m_status != 6) {
            return;
        }
        this.m_status = 7;
        LOG.debug("resume: Calling resume on trap receiver");
        this.m_trapListener.start();
        this.m_status = 2;
        LOG.debug("resume: Trapd resumed");
    }

    protected synchronized void onStop() {
        this.m_status = 3;
        LOG.debug("stop: Closing communication paths");
        this.m_trapListener.stop();
        this.m_status = 4;
        LOG.debug("stop: Trapd stopped");
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadEvent(IEvent e) {
        DaemonTools.handleReloadEvent((IEvent)e, (String)LOG4J_CATEGORY, event -> this.handleConfigurationChanged());
    }

    private void handleConfigurationChanged() {
        this.stop();
        try {
            this.m_trapListener.reload();
            this.publishListenerConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.start();
    }

    public void publishListenerConfig() throws IOException {
        this.m_config = TrapdConfigFactory.getInstance();
        this.m_twinSession.publish((Object)this.from(this.m_config));
    }

    public static SnmpV3User interpolateUser(SnmpV3User snmpV3User, Scope scope) {
        SnmpV3User interpolatedSnmpV3User = new SnmpV3User();
        interpolatedSnmpV3User.setEngineId(Interpolator.interpolate((String)snmpV3User.getEngineId(), (Scope)scope).output);
        interpolatedSnmpV3User.setSecurityLevel(snmpV3User.getSecurityLevel());
        interpolatedSnmpV3User.setSecurityName(Interpolator.interpolate((String)snmpV3User.getSecurityName(), (Scope)scope).output);
        interpolatedSnmpV3User.setAuthProtocol(Interpolator.interpolate((String)snmpV3User.getAuthProtocol(), (Scope)scope).output);
        interpolatedSnmpV3User.setPrivProtocol(Interpolator.interpolate((String)snmpV3User.getPrivProtocol(), (Scope)scope).output);
        interpolatedSnmpV3User.setPrivPassPhrase(Interpolator.interpolate((String)snmpV3User.getPrivPassPhrase(), (Scope)scope).output);
        interpolatedSnmpV3User.setAuthPassPhrase(Interpolator.interpolate((String)snmpV3User.getAuthPassPhrase(), (Scope)scope).output);
        return interpolatedSnmpV3User;
    }

    public static Snmpv3User interpolateUser(Snmpv3User snmpv3User, Scope scope) {
        Snmpv3User interpolatedSnmpV3User = new Snmpv3User();
        interpolatedSnmpV3User.setEngineId(Interpolator.interpolate((String)snmpv3User.getEngineId(), (Scope)scope).output);
        interpolatedSnmpV3User.setSecurityLevel(snmpv3User.getSecurityLevel());
        interpolatedSnmpV3User.setSecurityName(Interpolator.interpolate((String)snmpv3User.getSecurityName(), (Scope)scope).output);
        interpolatedSnmpV3User.setAuthProtocol(Interpolator.interpolate((String)snmpv3User.getAuthProtocol(), (Scope)scope).output);
        interpolatedSnmpV3User.setPrivacyProtocol(Interpolator.interpolate((String)snmpv3User.getPrivacyProtocol(), (Scope)scope).output);
        interpolatedSnmpV3User.setPrivacyPassphrase(Interpolator.interpolate((String)snmpv3User.getPrivacyPassphrase(), (Scope)scope).output);
        interpolatedSnmpV3User.setAuthPassphrase(Interpolator.interpolate((String)snmpv3User.getAuthPassphrase(), (Scope)scope).output);
        return interpolatedSnmpV3User;
    }

    public SnmpV3User interpolateUser(SnmpV3User snmpV3User) {
        return Trapd.interpolateUser(snmpV3User, (Scope)new SecureCredentialsVaultScope(this.secureCredentialsVault));
    }

    public Snmpv3User interpolateUser(Snmpv3User snmpv3User) {
        return Trapd.interpolateUser(snmpv3User, (Scope)new SecureCredentialsVaultScope(this.secureCredentialsVault));
    }

    public TrapListenerConfig from(TrapdConfig config) {
        TrapListenerConfig result = new TrapListenerConfig();
        SecureCredentialsVaultScope scope = new SecureCredentialsVaultScope(this.secureCredentialsVault);
        result.setSnmpV3Users(config.getSnmpV3Users().stream().map(arg_0 -> Trapd.lambda$from$1((Scope)scope, arg_0)).collect(Collectors.toList()));
        return result;
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }

    private static /* synthetic */ SnmpV3User lambda$from$1(Scope scope, SnmpV3User e) {
        return Trapd.interpolateUser(e, scope);
    }
}

