/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.model.ResourcePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCollectionResource
implements CollectionResource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCollectionResource.class);
    protected final CollectionAgent m_agent;
    private final Map<AttributeGroupType, AttributeGroup> m_attributeGroups = new LinkedHashMap<AttributeGroupType, AttributeGroup>();
    private final Map<String, String> m_tags = Maps.newHashMap();
    private final Map<String, String> m_serviceParams = Maps.newHashMap();

    protected AbstractCollectionResource(CollectionAgent agent) {
        this.m_agent = agent;
    }

    @Override
    public final String getOwnerName() {
        return this.m_agent.getHostAddress();
    }

    @Override
    public ResourcePath getPath() {
        return this.m_agent.getStorageResourcePath();
    }

    public final void addAttribute(CollectionAttribute attr) {
        AttributeGroup group = this.getGroup(attr.getAttributeType().getGroupType());
        LOG.debug("Adding attribute {}: {} to group {}", new Object[]{attr.getClass().getName(), attr, group});
        group.addAttribute(attr);
    }

    public final AttributeGroup getGroup(AttributeGroupType groupType) {
        AttributeGroup group = this.m_attributeGroups.get(groupType);
        if (group == null) {
            group = new AttributeGroup(this, groupType);
            this.m_attributeGroups.put(groupType, group);
        }
        return group;
    }

    @Override
    public void visit(CollectionSetVisitor visitor) {
        visitor.visitResource(this);
        for (AttributeGroup group : this.m_attributeGroups.values()) {
            group.visit(visitor);
        }
        visitor.completeResource(this);
    }

    @Override
    public final ResourcePath getParent() {
        return this.m_agent.getStorageResourcePath();
    }

    @Override
    public final boolean rescanNeeded() {
        return false;
    }

    @Override
    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    @Override
    public String getInterfaceLabel() {
        return null;
    }

    @Override
    public TimeKeeper getTimeKeeper() {
        return null;
    }

    @Override
    public Map<String, String> getTags() {
        return this.m_tags;
    }

    @Override
    public Map<String, String> getServiceParams() {
        return this.m_serviceParams;
    }

    public void addServiceParam(String name, String value) {
        this.m_serviceParams.put(name, value);
    }

    public void addTag(String name, String value) {
        this.m_tags.put(name, value);
    }
}

