/*
 * Decompiled with CFR 0.152.
 */
package geo.google.datamodel;

import geo.google.datamodel.GeoAltitude;
import geo.google.datamodel.GeoUtils;
import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class GeoCoordinate
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1060639455041268729L;
    private double _latitude = -1.0;
    private double _longitude = -1.0;
    private GeoAltitude _altitude = new GeoAltitude();

    public GeoCoordinate() {
    }

    public GeoCoordinate(double longitude, double latitude, GeoAltitude altitude) {
        this._latitude = latitude;
        this._longitude = longitude;
        this._altitude = altitude;
    }

    public double getLatitude() {
        return this._latitude;
    }

    public void setLatitude(double latitude) {
        this._latitude = latitude;
    }

    public double getLongitude() {
        return this._longitude;
    }

    public void setLongitude(double longitude) {
        this._longitude = longitude;
    }

    public GeoAltitude getAltitude() {
        return this._altitude;
    }

    public void setAltitude(GeoAltitude altitude) {
        this._altitude = altitude;
    }

    public double distanceTo(GeoCoordinate other) {
        return GeoUtils.distanceBetweenInMiles(this, other);
    }

    public GeoCoordinate clone() {
        return new GeoCoordinate(this._longitude, this._latitude, this._altitude.clone());
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

