/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.response;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultilineOrientedResponse {
    private static final Logger LOG = LoggerFactory.getLogger(MultilineOrientedResponse.class);
    private BufferedReader m_in;
    private List<String> m_responseList = new ArrayList<String>();

    public void addLine(String line) {
        this.getResponseList().add(line);
    }

    public void receive(BufferedReader in) {
        this.m_in = in;
    }

    public boolean startsWith(String prefix) {
        for (String line : this.getResponseList()) {
            if (line.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    public boolean expectedCodeRange(int beginCodeRange, int endCodeRange) {
        for (String line : this.getResponseList()) {
            if (this.validateCodeRange(this.getCode(line), beginCodeRange, endCodeRange)) continue;
            return false;
        }
        return true;
    }

    private String getCode(String firstResponseLine) {
        return firstResponseLine.substring(0, 3);
    }

    public boolean containedInHTTP(String pattern, String url, boolean isCheckCode, int maxRetCode) {
        block5: {
            int checkMaxRetCode = maxRetCode;
            try {
                String response = this.getEntireResponse(this.m_in);
                LOG.debug("Checking http response, pattern: {}  URL: {}  isCheckCode: {}  MaxRetCode: {}\n", new Object[]{pattern, url, isCheckCode, checkMaxRetCode});
                if (response == null || !response.contains(pattern)) break block5;
                LOG.debug("Return from server was: {}", (Object)response);
                if (isCheckCode) {
                    if ("/".equals(url) || !isCheckCode) {
                        checkMaxRetCode = 600;
                    }
                    StringTokenizer t = new StringTokenizer(response);
                    t.nextToken();
                    String codeString = t.nextToken();
                    if (this.validateCodeRange(codeString, 99, checkMaxRetCode)) {
                        LOG.debug("RetCode Passed");
                        return true;
                    }
                    break block5;
                }
                LOG.debug("isAServer");
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private String getEntireResponse(BufferedReader in) throws IOException {
        StringBuilder response;
        block3: {
            char[] cbuf = new char[1024];
            int chars = 0;
            response = new StringBuilder();
            try {
                while ((chars = in.read(cbuf, 0, 1024)) != -1) {
                    response.append(cbuf, 0, chars);
                }
            }
            catch (SocketTimeoutException timeoutEx) {
                if (timeoutEx.bytesTransferred <= 0) break block3;
                response.append(cbuf, 0, timeoutEx.bytesTransferred);
            }
        }
        return response.toString();
    }

    private boolean validateCodeRange(String codeString, int beginCodeRange, int endCodeRange) {
        try {
            int code = Integer.parseInt(codeString);
            return code >= beginCodeRange && code <= endCodeRange;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.getResponseList().isEmpty() ? "MultilineOrientedResponse" : String.format("Response: %s", this.getResponseList().toArray());
    }

    public void setResponseList(List<String> responseList) {
        this.m_responseList = responseList;
    }

    public List<String> getResponseList() {
        return this.m_responseList;
    }
}

