/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.msexchange.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.detector.msexchange.response.MSExchangeResponse;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.support.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSExchangeDetectorClient
implements Client<LineOrientedRequest, MSExchangeResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(MSExchangeDetectorClient.class);
    private Integer m_imapPort;
    private Integer m_pop3Port;
    private String m_pop3Response;
    private String m_imapResponse;

    public void close() {
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        this.setImapResponse(this.connectAndGetResponse(address, this.getImapPort(), timeout));
        this.setPop3Response(this.connectAndGetResponse(address, this.getPop3Port(), timeout));
    }

    private String connectAndGetResponse(InetAddress address, Integer port, int timeout) {
        block5: {
            Socket socket = null;
            InputStreamReader isr = null;
            BufferedReader lineRdr = null;
            if (port != null) {
                try {
                    socket = new Socket();
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(address, (int)port);
                    socket.connect(inetSocketAddress, timeout);
                    socket.setSoTimeout(timeout);
                    isr = new InputStreamReader(socket.getInputStream());
                    lineRdr = new BufferedReader(isr);
                    String banner = lineRdr.readLine();
                    socket.close();
                    return banner;
                }
                catch (Exception e) {
                    LOG.debug("An error occurred while connecting to {}:{}", new Object[]{InetAddressUtils.str((InetAddress)address), port, e});
                    IOUtils.closeQuietly(lineRdr);
                    IOUtils.closeQuietly((Reader)isr);
                    if (socket == null) break block5;
                    try {
                        socket.close();
                    }
                    catch (IOException e1) {
                        LOG.debug("Additionally, an exception occurred while trying to close the socket.", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    public MSExchangeResponse receiveBanner() throws IOException, Exception {
        MSExchangeResponse response = new MSExchangeResponse();
        response.setPop3Response(this.getPop3Response());
        response.setImapResponse(this.getImapResponse());
        return response;
    }

    public MSExchangeResponse sendRequest(LineOrientedRequest request) throws IOException, Exception {
        return null;
    }

    public void setImapPort(int imapPort) {
        this.m_imapPort = imapPort;
    }

    public Integer getImapPort() {
        return this.m_imapPort;
    }

    public void setFtpPort(int ftpPort) {
        this.m_pop3Port = ftpPort;
    }

    public Integer getPop3Port() {
        return this.m_pop3Port;
    }

    public void setPop3Port(int pop3Port) {
        this.m_pop3Port = pop3Port;
    }

    public void setImapResponse(String imapResponse) {
        this.m_imapResponse = imapResponse;
    }

    public String getImapResponse() {
        return this.m_imapResponse;
    }

    public void setPop3Response(String pop3Response) {
        this.m_pop3Response = pop3Response;
    }

    public String getPop3Response() {
        return this.m_pop3Response;
    }
}

