/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.karaf.main.Main;
import org.opennms.core.soa.support.OnmsOSGiBridgeActivator;
import org.osgi.framework.BundleContext;

public class WebAppListener
implements ServletContextListener {
    private Main main;
    private ServletContext m_servletContext;
    private BundleContext m_framework;
    private OnmsOSGiBridgeActivator m_bridge = new OnmsOSGiBridgeActivator();

    public void contextInitialized(ServletContextEvent sce) {
        try {
            this.m_servletContext = sce.getServletContext();
            File karafRoot = new File(this.m_servletContext.getRealPath("/") + "/WEB-INF/karaf");
            String opennmsHome = System.getProperty("opennms.home");
            if (opennmsHome != null) {
                karafRoot = new File(opennmsHome);
            }
            this.m_servletContext.log("contextInitialized");
            String root = karafRoot.getAbsolutePath();
            this.m_servletContext.log("Root: " + root);
            System.setProperty("karaf.home", root);
            System.setProperty("karaf.base", root);
            System.setProperty("karaf.data", root + File.separator + "data");
            System.setProperty("karaf.log", root + File.separator + "logs");
            System.setProperty("karaf.etc", root + File.separator + "etc");
            System.setProperty("karaf.history", root + File.separator + "data" + File.separator + "history.txt");
            System.setProperty("karaf.instances", root + File.separator + "instances");
            System.setProperty("karaf.startLocalConsole", "false");
            System.setProperty("karaf.startRemoteShell", "true");
            System.setProperty("karaf.lock", "false");
            this.main = new Main(new String[0]);
            this.main.launch();
            this.m_framework = this.main.getFramework().getBundleContext();
            this.m_servletContext.setAttribute(BundleContext.class.getName(), (Object)this.m_framework);
            this.m_bridge.start(this.m_framework);
        }
        catch (Throwable e) {
            this.m_servletContext.log("Unexpected exception while starting Karaf", e);
            this.main = null;
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            this.m_bridge.stop(this.m_framework);
            this.m_servletContext.log("contextDestroyed");
            if (this.main != null) {
                this.main.destroy();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

