/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.operations;

import com.google.common.base.Strings;
import java.net.InetAddress;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.operations.ImportOperation;
import org.opennms.netmgt.provision.service.operations.ScanManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;

public abstract class SaveOrUpdateOperation
extends ImportOperation {
    private static final Logger LOG = LoggerFactory.getLogger(SaveOrUpdateOperation.class);
    private final OnmsNode m_node;
    private final String monitorKey;
    private OnmsIpInterface m_currentInterface;
    private OnmsMonitoredService m_currentService;
    private ScanManager m_scanManager;
    private String m_rescanExisting = Boolean.TRUE.toString();

    protected SaveOrUpdateOperation(Integer nodeId, String foreignSource, String foreignId, String nodeLabel, String location, String building, String city, ProvisionService provisionService, String rescanExisting, String monitorKey) {
        super(provisionService);
        this.m_node = new OnmsNode();
        this.m_node.setLocation(Strings.isNullOrEmpty((String)location) ? new OnmsMonitoringLocation("Default", "Default") : new OnmsMonitoringLocation(location, location));
        this.m_node.setLabel(nodeLabel);
        this.m_node.setId(nodeId);
        this.m_node.setLabelSource(OnmsNode.NodeLabelSource.USER);
        this.m_node.setType(OnmsNode.NodeType.ACTIVE);
        this.m_node.setForeignSource(foreignSource);
        this.m_node.setForeignId(foreignId);
        this.m_node.getAssetRecord().setBuilding(building);
        this.m_node.getAssetRecord().setCity(city);
        this.m_rescanExisting = rescanExisting;
        this.monitorKey = monitorKey;
    }

    public ScanManager getScanManager() {
        return this.m_scanManager;
    }

    public void foundInterface(InetAddress addr, Object descr, PrimaryType primaryType, boolean managed, int status, Set<CompletableFuture<Void>> dnsLookups) {
        if (addr == null) {
            LOG.error("Found interface on node {} with an empty/invalid ipaddr! Ignoring!", (Object)this.m_node.getLabel());
            return;
        }
        this.m_currentInterface = new OnmsIpInterface(addr, this.m_node);
        this.m_currentInterface.setIsManaged(status == 3 ? "U" : "M");
        this.m_currentInterface.setIsSnmpPrimary(primaryType);
        if (PrimaryType.PRIMARY.equals((Object)primaryType) && addr != null) {
            this.m_scanManager = new ScanManager(this.getProvisionService().getLocationAwareSnmpClient(), addr);
        }
        this.m_node.addIpInterface(this.m_currentInterface);
        if (System.getProperty("org.opennms.provisiond.reverseResolveRequisitionIpInterfaceHostnames", "true").equalsIgnoreCase("true")) {
            dnsLookups.add((CompletableFuture<Void>)this.getProvisionService().getHostnameResolver().getHostnameAsync(addr, this.m_node.getLocation().getLocationName()).thenAccept(s -> this.m_node.getInterfaceWithAddress(addr).setIpHostName(s)));
        }
    }

    @Override
    public void scan() {
        this.updateSnmpData();
    }

    protected void updateSnmpData() {
        if (this.m_scanManager != null) {
            this.m_scanManager.updateSnmpData(this.m_node, this.getProvisionService().getHostnameResolver());
        }
    }

    public void foundMonitoredService(String serviceName) {
        if (this.m_currentInterface != null) {
            OnmsServiceType svcType = this.getProvisionService().createServiceTypeIfNecessary(serviceName);
            this.m_currentService = new OnmsMonitoredService(this.m_currentInterface, svcType);
            this.m_currentService.setStatus("A");
            this.m_currentInterface.getMonitoredServices().add(this.m_currentService);
        }
    }

    public void foundCategory(String name) {
        OnmsCategory category = this.getProvisionService().createCategoryIfNecessary(name);
        this.m_node.getCategories().add(category);
    }

    protected OnmsNode getNode() {
        return this.m_node;
    }

    protected String getRescanExisting() {
        return this.m_rescanExisting;
    }

    public String getMonitorKey() {
        return this.monitorKey;
    }

    public void foundAsset(String name, String value) {
        BeanWrapper w = PropertyAccessorFactory.forBeanPropertyAccess((Object)this.m_node.getAssetRecord());
        try {
            w.setPropertyValue(name, (Object)value);
        }
        catch (BeansException e) {
            LOG.warn("Could not set property on object of type {}: {}", new Object[]{this.m_node.getClass().getName(), name, e});
        }
    }

    public void foundNodeMetaData(String context, String key, String value) {
        this.m_node.addMetaData(context, key, value);
    }

    public void foundInterfaceMetaData(String context, String key, String value) {
        this.m_currentInterface.addMetaData(context, key, value);
    }

    public void foundServiceMetaData(String context, String key, String value) {
        this.m_currentService.addMetaData(context, key, value);
    }

    @Override
    public ImportOperation.OperationType getOperationType() {
        return ImportOperation.OperationType.UPDATE;
    }
}

