/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.provision.persist.RequisitionVisitor;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.RequisitionAccountant;
import org.opennms.netmgt.provision.service.operations.DeleteOperation;
import org.opennms.netmgt.provision.service.operations.ImportOperation;
import org.opennms.netmgt.provision.service.operations.InsertOperation;
import org.opennms.netmgt.provision.service.operations.NullUpdateOperation;
import org.opennms.netmgt.provision.service.operations.SaveOrUpdateOperation;
import org.opennms.netmgt.provision.service.operations.UpdateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportOperationsManager {
    private static final Logger LOG = LoggerFactory.getLogger(ImportOperationsManager.class);
    private final List<ImportOperation> m_inserts = new LinkedList<ImportOperation>();
    private final List<ImportOperation> m_updates = new LinkedList<ImportOperation>();
    private final ProvisionService m_provisionService;
    private final Map<String, Integer> m_foreignIdToNodeMap;
    private String m_rescanExisting;
    private String m_foreignSource;

    public ImportOperationsManager(Map<String, Integer> foreignIdToNodeMap, ProvisionService provisionService, String rescanExisting) {
        this.m_provisionService = provisionService;
        this.m_foreignIdToNodeMap = new HashMap<String, Integer>(foreignIdToNodeMap);
        this.m_rescanExisting = rescanExisting;
    }

    public SaveOrUpdateOperation foundNode(String foreignId, String nodeLabel, String location, String building, String city, String monitorKey) {
        SaveOrUpdateOperation ret = this.nodeExists(foreignId) ? this.updateNode(foreignId, nodeLabel, location, building, city, monitorKey) : this.insertNode(foreignId, nodeLabel, location, building, city, monitorKey);
        return ret;
    }

    private boolean nodeExists(String foreignId) {
        return this.m_foreignIdToNodeMap.containsKey(foreignId);
    }

    private SaveOrUpdateOperation insertNode(String foreignId, String nodeLabel, String location, String building, String city, String monitorKey) {
        InsertOperation insertOperation = new InsertOperation(this.getForeignSource(), foreignId, nodeLabel, location, building, city, this.m_provisionService, monitorKey);
        this.m_inserts.add(insertOperation);
        return insertOperation;
    }

    private SaveOrUpdateOperation updateNode(String foreignId, String nodeLabel, String location, String building, String city, String monitorKey) {
        Integer nodeId = this.processForeignId(foreignId);
        UpdateOperation updateOperation = Boolean.valueOf(this.m_rescanExisting) != false || this.m_rescanExisting.equalsIgnoreCase("dbonly") ? new UpdateOperation(nodeId, this.getForeignSource(), foreignId, nodeLabel, location, building, city, this.m_provisionService, this.m_rescanExisting, monitorKey) : new NullUpdateOperation(nodeId, this.getForeignSource(), foreignId, nodeLabel, location, building, city, this.m_provisionService, this.m_rescanExisting, monitorKey);
        this.m_updates.add(updateOperation);
        return updateOperation;
    }

    private Integer processForeignId(String foreignId) {
        return this.m_foreignIdToNodeMap.remove(foreignId);
    }

    public int getOperationCount() {
        return this.m_inserts.size() + this.m_updates.size() + this.m_foreignIdToNodeMap.size();
    }

    public int getInsertCount() {
        return this.m_inserts.size();
    }

    public int getUpdateCount() {
        return this.m_updates.size();
    }

    public int getDeleteCount() {
        return this.m_foreignIdToNodeMap.size();
    }

    public void shutdownAndWaitForCompletion(ExecutorService executorService, String msg) {
        executorService.shutdown();
        try {
            while (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException e) {
            LOG.error(msg, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public Collection<ImportOperation> getOperations() {
        return Collections.list(new OperationIterator());
    }

    private Runnable sequence(final Executor pool, final Runnable a, final Runnable b) {
        return new Runnable(){

            @Override
            public void run() {
                a.run();
                pool.execute(b);
            }
        };
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = foreignSource;
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public String getRescanExisting() {
        return this.m_rescanExisting;
    }

    public void auditNodes(Requisition requisition, String monitorKey) {
        requisition.visit((RequisitionVisitor)new RequisitionAccountant(this, monitorKey));
    }

    private Runnable persister(final ImportOperation oper) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                oper.persist();
            }
        };
        return r;
    }

    private Runnable scanner(final ImportOperation oper) {
        return new Runnable(){

            @Override
            public void run() {
                LOG.info("Preprocess: {}", (Object)oper);
                oper.scan();
            }
        };
    }

    private class OperationIterator
    implements Iterator<ImportOperation>,
    Enumeration<ImportOperation> {
        Iterator<Iterator<ImportOperation>> m_iterIter;
        Iterator<ImportOperation> m_currentIter;

        OperationIterator() {
            ArrayList<Iterator<ImportOperation>> iters = new ArrayList<Iterator<ImportOperation>>(3);
            iters.add(new DeleteIterator());
            iters.add(ImportOperationsManager.this.m_updates.iterator());
            iters.add(ImportOperationsManager.this.m_inserts.iterator());
            this.m_iterIter = iters.iterator();
        }

        @Override
        public boolean hasNext() {
            while ((this.m_currentIter == null || !this.m_currentIter.hasNext()) && this.m_iterIter.hasNext()) {
                this.m_currentIter = this.m_iterIter.next();
                this.m_iterIter.remove();
            }
            return this.m_currentIter == null ? false : this.m_currentIter.hasNext();
        }

        @Override
        public ImportOperation next() {
            return this.m_currentIter.next();
        }

        @Override
        public void remove() {
            this.m_currentIter.remove();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public ImportOperation nextElement() {
            return this.next();
        }
    }

    private class DeleteIterator
    implements Iterator<ImportOperation> {
        private final Iterator<Map.Entry<String, Integer>> m_foreignIdIterator;

        private DeleteIterator() {
            this.m_foreignIdIterator = ImportOperationsManager.this.m_foreignIdToNodeMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.m_foreignIdIterator.hasNext();
        }

        @Override
        public ImportOperation next() {
            Map.Entry<String, Integer> entry = this.m_foreignIdIterator.next();
            return new DeleteOperation(entry.getValue(), ImportOperationsManager.this.getForeignSource(), entry.getKey(), ImportOperationsManager.this.m_provisionService);
        }

        @Override
        public void remove() {
            this.m_foreignIdIterator.remove();
        }
    }
}

