/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.util.Collection;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.provision.ProvisioningAdapter;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.service.PluginRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

@EventListener(name="ProvisioningAdapterManager:EventListener", logPrefix="provisiond")
public class ProvisioningAdapterManager
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ProvisioningAdapterManager.class);
    private PluginRegistry m_pluginRegistry;
    private Collection<ProvisioningAdapter> m_adapters;
    private volatile EventForwarder m_eventForwarder;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_pluginRegistry, (String)"pluginRegistry must be set");
        this.m_adapters = this.m_pluginRegistry.getAllPlugins(ProvisioningAdapter.class);
    }

    public PluginRegistry getPluginRegistry() {
        return this.m_pluginRegistry;
    }

    public void setPluginRegistry(PluginRegistry pluginRegistry) {
        this.m_pluginRegistry = pluginRegistry;
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeAdded")
    public void handleNodeAddedEvent(IEvent e) {
        for (ProvisioningAdapter adapter : this.m_adapters) {
            LOG.info("handleNodeAddedEvent: Calling adapter:{} for node: {}", (Object)adapter.getName(), (Object)e.getNodeid());
            try {
                adapter.addNode(e.getNodeid().intValue());
            }
            catch (ProvisioningAdapterException pae) {
                LOG.error("handleNodeAddedEvent: Adapter threw known exception: {}", (Object)adapter.getName(), (Object)pae);
            }
            catch (Throwable t) {
                LOG.error("handleNodeAddedEvent: Unanticpated exception when calling adapter: {}", (Object)adapter.getName(), (Object)t);
            }
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeUpdated")
    public void handleNodeUpdatedEvent(IEvent e) {
        for (ProvisioningAdapter adapter : this.m_adapters) {
            LOG.info("handleNodeUpdatedEvent: Calling adapter:{} for node: {}", (Object)adapter.getName(), (Object)e.getNodeid());
            try {
                adapter.updateNode(e.getNodeid().intValue());
            }
            catch (ProvisioningAdapterException pae) {
                LOG.error("handleNodeUpdatedEvent: Adapter threw known exception: {}", (Object)adapter.getName(), (Object)pae);
            }
            catch (Throwable t) {
                LOG.error("handleNodeUpdatedEvent: Unanticpated exception when calling adapter: {}", (Object)adapter.getName(), (Object)t);
            }
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDeleted")
    public void handleNodeDeletedEvent(IEvent e) {
        for (ProvisioningAdapter adapter : this.m_adapters) {
            LOG.info("handleNodeDeletedEvent: Calling adapter:{} for node: {}", (Object)adapter.getName(), (Object)e.getNodeid());
            try {
                adapter.deleteNode(e.getNodeid().intValue());
            }
            catch (ProvisioningAdapterException pae) {
                LOG.error("handleNodeDeletedEvent: Adapter threw known exception: {}", (Object)adapter.getName(), (Object)pae);
            }
            catch (Throwable t) {
                LOG.error("handleNodeDeletedEvent: Unanticpated exception when calling adapter: {}", (Object)adapter.getName(), (Object)t);
            }
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/provisiond/nodeScanCompleted")
    public void handleNodeScanCompletedEvent(IEvent e) {
        for (ProvisioningAdapter adapter : this.m_adapters) {
            LOG.info("handleScanCompletedEvent: Calling adapter:{} for node: {}", (Object)adapter.getName(), (Object)e.getNodeid());
            try {
                adapter.updateNode(e.getNodeid().intValue());
            }
            catch (ProvisioningAdapterException pae) {
                LOG.error("handleNodeScanCompletedEvent: Adapter threw known exception: {}", (Object)adapter.getName(), (Object)pae);
            }
            catch (Throwable t) {
                LOG.error("handleNodeScanCompletedEvent: Unanticpated exception when calling adapter: {}", (Object)adapter.getName(), (Object)t);
            }
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/translator/entityConfigChanged")
    public void handleNodeChangedEvent(IEvent e) {
        for (ProvisioningAdapter adapter : this.m_adapters) {
            LOG.info("handleNodeChangedEvent: Calling adapter:{} for node: {}", (Object)adapter.getName(), (Object)e.getNodeid());
            try {
                if (e.getNodeid() != 0L) {
                    adapter.nodeConfigChanged(e.getNodeid().intValue());
                    continue;
                }
                LOG.warn("handleNodeChangedEvent: received configChanged event without nodeId: {}", (Object)e);
            }
            catch (ProvisioningAdapterException pae) {
                LOG.error("handleNodeChangedEvent: Adapter threw known exception: {}", (Object)adapter.getName(), (Object)pae);
            }
            catch (Throwable t) {
                LOG.error("handleNodeChangedEvent: Unanticpated exception when calling adapter: {}", (Object)adapter.getName(), (Object)t);
            }
        }
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void initializeAdapters() {
        for (ProvisioningAdapter adapter : this.m_adapters) {
            adapter.init();
        }
    }
}

