/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.topology;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.features.topology.api.IconRepository;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.MetaTopologyProvider;
import org.opennms.features.topology.api.topo.SearchProvider;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentService;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.service.GraphContainerProvider;
import org.opennms.netmgt.graph.api.service.GraphService;
import org.opennms.netmgt.graph.api.service.osgi.GraphContainerProviderRegistration;
import org.opennms.netmgt.graph.provider.topology.LegacyIconRepositoryAdapter;
import org.opennms.netmgt.graph.provider.topology.LegacyMetaTopologyProvider;
import org.opennms.netmgt.graph.provider.topology.LegacyStatusProvider;
import org.opennms.netmgt.graph.provider.topology.LegacyTopologyConfiguration;
import org.opennms.netmgt.graph.provider.topology.LegacyTopologyProvider;
import org.opennms.netmgt.graph.provider.topology.LegacyTopologySearchProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class GraphContainerProviderManager {
    private final BundleContext bundleContext;
    private final Map<GraphContainerProvider, List<ServiceRegistration<?>>> serviceRegistrations = Maps.newHashMap();
    private final GraphService graphService;
    private final EnrichmentService enrichmentService;
    private final NodeDao nodeDao;
    private final AlarmDao alarmDao;

    public GraphContainerProviderManager(BundleContext bundlecontext, GraphService graphService, EnrichmentService enrichmentService, NodeDao nodeDao, AlarmDao alarmDao) {
        this.bundleContext = Objects.requireNonNull(bundlecontext);
        this.graphService = Objects.requireNonNull(graphService);
        this.enrichmentService = Objects.requireNonNull(enrichmentService);
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.alarmDao = Objects.requireNonNull(alarmDao);
    }

    public void onBind(GraphContainerProviderRegistration containerProviderRegistration, Map<String, String> properties) {
        GraphContainerProvider containerProvider = containerProviderRegistration.getDelegate();
        LegacyTopologyConfigurationImpl configuration = new LegacyTopologyConfigurationImpl(properties);
        if (configuration.isExposeToTopology()) {
            this.serviceRegistrations.putIfAbsent(containerProvider, Lists.newArrayList());
            GraphContainerInfo containerInfo = containerProvider.getContainerInfo();
            String containerId = containerInfo.getId();
            Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
            serviceProperties.put("label", containerInfo.getLabel());
            LegacyMetaTopologyProvider metaTopologyProvider = new LegacyMetaTopologyProvider(configuration, this.nodeDao, this.graphService, this.enrichmentService, containerId);
            ServiceRegistration metaTopologyProviderServiceRegistration = this.bundleContext.registerService(MetaTopologyProvider.class, (Object)metaTopologyProvider, serviceProperties);
            metaTopologyProvider.getGraphProviders().forEach(topologyProvider -> {
                LegacyTopologySearchProvider searchProvider = new LegacyTopologySearchProvider((LegacyTopologyProvider)topologyProvider);
                ServiceRegistration registeredSearchProviderServiceRegistration = this.bundleContext.registerService(SearchProvider.class, (Object)searchProvider, new Hashtable());
                this.serviceRegistrations.get(containerProvider).add(registeredSearchProviderServiceRegistration);
            });
            metaTopologyProvider.getGraphProviders().forEach(topologyProvider -> {
                ServiceRegistration iconRepositoryServiceRegistration = this.bundleContext.registerService(IconRepository.class, (Object)new LegacyIconRepositoryAdapter((GraphProvider)topologyProvider), new Hashtable());
                this.serviceRegistrations.get(containerProvider).add(iconRepositoryServiceRegistration);
            });
            if (configuration.isExposeStatusProvider()) {
                metaTopologyProvider.getGraphProviders().forEach(topologyProvider -> {
                    LegacyStatusProvider statusProvider = new LegacyStatusProvider(topologyProvider.getNamespace(), this.alarmDao);
                    ServiceRegistration statusProviderServiceRegistration = this.bundleContext.registerService(StatusProvider.class, (Object)statusProvider, new Hashtable());
                    ServiceRegistration edgeStatusProviderServiceRegistration = this.bundleContext.registerService(EdgeStatusProvider.class, (Object)statusProvider, new Hashtable());
                    this.serviceRegistrations.get(containerProvider).add(statusProviderServiceRegistration);
                    this.serviceRegistrations.get(containerProvider).add(edgeStatusProviderServiceRegistration);
                });
            }
            this.serviceRegistrations.get(containerProvider).add(metaTopologyProviderServiceRegistration);
        }
    }

    public void onUnbind(GraphContainerProviderRegistration containerProviderRegistration, Map<String, String> properties) {
        List<ServiceRegistration<?>> removedServices;
        if (containerProviderRegistration != null && (removedServices = this.serviceRegistrations.remove(containerProviderRegistration.getDelegate())) != null) {
            for (ServiceRegistration<?> removedService : removedServices) {
                if (removedService == null) continue;
                removedService.unregister();
            }
        }
    }

    private static class LegacyTopologyConfigurationImpl
    implements LegacyTopologyConfiguration {
        private final Map<String, String> properties;

        public LegacyTopologyConfigurationImpl(Map<String, String> properties) {
            this.properties = Objects.requireNonNull(properties);
        }

        public boolean isExposeToTopology() {
            return Boolean.valueOf(this.properties.get("expose-to-topology"));
        }

        @Override
        public boolean isExposeStatusProvider() {
            return Boolean.valueOf(this.properties.get("expose-status-provider"));
        }

        @Override
        public boolean isResolveNodeIds() {
            if (this.properties.get("enrichment.resolveNodes") != null) {
                return Boolean.parseBoolean(this.properties.get("enrichment.resolveNodes"));
            }
            return Boolean.parseBoolean(this.properties.get("resolve-node-ids"));
        }
    }
}

