/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jasper.helper;

import java.util.Date;
import java.util.GregorianCalendar;

public enum TimeRange {
    LAST_SEVEN_DAYS{

        @Override
        public Date getStartDate() {
            return new Date(new GregorianCalendar(new GregorianCalendar().get(1), new GregorianCalendar().get(2), new GregorianCalendar().get(5) - 7).getTimeInMillis());
        }
    }
    ,
    LAST_MONTH{

        @Override
        public Date getStartDate() {
            return new Date(new GregorianCalendar(new GregorianCalendar().get(1), new GregorianCalendar().get(2) - 1, 1).getTimeInMillis());
        }

        @Override
        public Date getEndDate() {
            return new Date(new GregorianCalendar(new GregorianCalendar().get(1), new GregorianCalendar().get(2), 0, 23, 59, 59).getTimeInMillis());
        }
    }
    ,
    LAST_YEAR{

        @Override
        public Date getStartDate() {
            return new Date(new GregorianCalendar(new GregorianCalendar().get(1) - 1, 0, 1).getTimeInMillis());
        }

        @Override
        public Date getEndDate() {
            return new Date(new GregorianCalendar(new GregorianCalendar().get(1) - 1, 12, 0, 23, 59, 59).getTimeInMillis());
        }
    }
    ,
    THIS_MONTH{

        @Override
        public Date getStartDate() {
            return new Date(new GregorianCalendar(new GregorianCalendar().get(1), new GregorianCalendar().get(2), 1).getTimeInMillis());
        }
    }
    ,
    THIS_YEAR{

        @Override
        public Date getStartDate() {
            return new Date(new GregorianCalendar(new GregorianCalendar().get(1), 0, 1).getTimeInMillis());
        }
    };


    public Date getEndDate() {
        return new Date(new GregorianCalendar(new GregorianCalendar().get(1), new GregorianCalendar().get(2), new GregorianCalendar().get(5)).getTimeInMillis());
    }

    public abstract Date getStartDate();

    public static Date getStartDate(String range) {
        TimeRange timeRange = TimeRange.getTimeRange(range);
        return timeRange != null ? timeRange.getStartDate() : null;
    }

    public static Date getEndDate(String range) {
        TimeRange timeRange = TimeRange.getTimeRange(range);
        return timeRange != null ? timeRange.getEndDate() : null;
    }

    private static TimeRange getTimeRange(String range) {
        for (TimeRange eachTimeRange : TimeRange.values()) {
            if (!eachTimeRange.name().equalsIgnoreCase(range)) continue;
            return eachTimeRange;
        }
        return null;
    }
}

