/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.wmi;

import java.io.PrintWriter;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.opennms.protocols.wmi.WmiManager;
import org.opennms.protocols.wmi.WmiParams;
import org.opennms.protocols.wmi.WmiResult;

public abstract class CheckWmi {
    public static void main(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("domain", true, "the NT/AD domain the credentials belong to");
        options.addOption("wmiClass", true, "the object class in WMI to query");
        options.addOption("wmiNamespace", true, "the namespace in WMI to use (default: root/cimv2)");
        options.addOption("wmiObject", true, "the object to query in WMI");
        options.addOption("wmiWql", true, "the query string to execute in WMI");
        options.addOption("op", true, "compare operation: NOOP, EQ, NEQ, GT, LT");
        options.addOption("value", true, "the value to compare to");
        options.addOption("matchType", true, "type of matching for multiple results: all, none, some, one");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        List arguments = cmd.getArgList();
        if (arguments.size() < 3) {
            CheckWmi.usage(options, cmd);
            System.exit(1);
        }
        String host = (String)arguments.remove(0);
        String user = (String)arguments.remove(0);
        String pass = (String)arguments.remove(0);
        String wmiClass = "";
        if (cmd.hasOption("wmiClass")) {
            wmiClass = cmd.getOptionValue("wmiClass");
        }
        String wmiObject = "";
        if (cmd.hasOption("wmiObject")) {
            wmiObject = cmd.getOptionValue("wmiObject");
        } else {
            CheckWmi.usage(options, cmd);
            System.exit(1);
        }
        String wmiNamespace = "root/cimv2";
        if (cmd.hasOption("wmiNamespace")) {
            wmiNamespace = cmd.getOptionValue("wmiNamespace");
        }
        String wmiWql = "";
        if (cmd.hasOption("wmiWql")) {
            wmiWql = cmd.getOptionValue("wmiWql");
        }
        String compVal = "";
        if (cmd.hasOption("value")) {
            compVal = cmd.getOptionValue("value");
        } else {
            CheckWmi.usage(options, cmd);
            System.exit(1);
        }
        String compOp = "";
        if (cmd.hasOption("op")) {
            compOp = cmd.getOptionValue("op");
        } else {
            CheckWmi.usage(options, cmd);
            System.exit(1);
        }
        String domain = "";
        if (cmd.hasOption("domain")) {
            domain = cmd.getOptionValue("domain");
        }
        String matchType = "all";
        if (cmd.hasOption("matchType")) {
            matchType = cmd.getOptionValue("matchType");
        }
        try {
            WmiParams clientParams = wmiWql == null || wmiWql.length() == 0 ? new WmiParams("InstanceOf", compVal, compOp, wmiClass, wmiObject) : new WmiParams("Wql", compVal, compOp, wmiWql, wmiObject);
            WmiManager mgr = new WmiManager(host, user, pass, domain, matchType);
            mgr.setNamespace(wmiNamespace);
            mgr.init();
            WmiResult result = mgr.performOp(clientParams);
            List<Object> wmiObjects = result.getResponse();
            System.out.println("Checking: " + wmiWql + " for " + wmiObject + " Op: " + compOp + " Val: " + compVal);
            System.out.println("Check results: " + WmiResult.convertStateToString(result.getResultCode()) + " (" + wmiObjects.size() + ")");
            for (int i = 0; i < wmiObjects.size(); ++i) {
                System.out.println("Result for (" + (i + 1) + ") " + wmiClass + "\\" + wmiObject + ": " + wmiObjects.get(i));
            }
            mgr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void usage(Options options, CommandLine cmd, String error, Exception e) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(System.out);
        if (error != null) {
            pw.println("An error occurred: " + error + "\n");
        }
        formatter.printHelp("usage: CheckWmi [options] <host> <username> <password>", options);
        if (e != null) {
            pw.println(e.getMessage());
            e.printStackTrace(pw);
        }
        pw.close();
    }

    private static void usage(Options options, CommandLine cmd) {
        CheckWmi.usage(options, cmd, null, null);
    }
}

