/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jolokia.jvmagent.security.asn1.DERObject;
import org.jolokia.jvmagent.security.asn1.DERUtils;

public class DERSequence
implements DERObject {
    public static final byte DER_SEQUENCE_TAG = 48;
    private final DERObject[] values;

    public DERSequence(DERObject[] values) {
        this.values = values;
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        try {
            for (DERObject v : this.values) {
                content.write(v.getEncoded());
            }
            byte[] bytes = content.toByteArray();
            result.write(48);
            result.write(DERUtils.encodeLength(bytes.length));
            result.write(bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toByteArray();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

