/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client.command;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.jolokia.jvmagent.client.util.OptionsAndArgs;
import org.jolokia.jvmagent.client.util.VirtualMachineHandlerOperations;

public abstract class AbstractBaseCommand {
    abstract String getName();

    abstract int execute(OptionsAndArgs var1, Object var2, VirtualMachineHandlerOperations var3) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException;

    protected void loadAgent(Object pVm, VirtualMachineHandlerOperations pHandler, OptionsAndArgs pOpts, String ... pAdditionalOpts) {
        String args = pOpts.toAgentArg();
        if (pAdditionalOpts.length > 0) {
            args = args.length() != 0 ? args + "," + pAdditionalOpts[0] : pAdditionalOpts[0];
        }
        pHandler.loadAgent(pVm, pOpts.getJarFilePath(), args.length() > 0 ? args : null);
    }

    protected String checkAgentUrl(Object pVm, VirtualMachineHandlerOperations pHandler) {
        return this.checkAgentUrl(pVm, pHandler, 0);
    }

    protected String checkAgentUrl(Object pVm, VirtualMachineHandlerOperations pHandler, int delayInMs) {
        if (delayInMs != 0) {
            try {
                Thread.sleep(delayInMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Properties systemProperties = this.getAgentSystemProperties(pVm, pHandler);
        return systemProperties.getProperty("jolokia.agent");
    }

    protected Properties getAgentSystemProperties(Object pVm, VirtualMachineHandlerOperations pHandler) {
        return pHandler.getSystemProperties(pVm);
    }

    protected String getProcessDescription(VirtualMachineHandlerOperations pHandler, OptionsAndArgs pOpts) {
        if (pOpts.getPid() != null) {
            return "PID " + pOpts.getPid();
        }
        if (pOpts.getProcessPattern() != null) {
            StringBuffer desc = new StringBuffer("process matching \"").append(pOpts.getProcessPattern().pattern()).append("\"");
            desc.append(" (PID: ").append(pHandler.findProcess(pOpts.getProcessPattern()).getId()).append(")");
            return desc.toString();
        }
        return "(null)";
    }
}

