/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.DataImporter;
import org.jrobin.core.RrdAllocator;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdInt;
import org.jrobin.core.RrdLong;
import org.jrobin.core.RrdString;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;

public class Header
implements RrdUpdater {
    static final int SIGNATURE_LENGTH = 2;
    static final String SIGNATURE = "JR";
    static final String DEFAULT_SIGNATURE = "JRobin, version 0.1";
    static final String RRDTOOL_VERSION = "0001";
    private RrdDb parentDb;
    private RrdString signature;
    private RrdLong step;
    private RrdInt dsCount;
    private RrdInt arcCount;
    private RrdLong lastUpdateTime;
    private Long m_primitiveStep = null;
    private Integer m_primitiveDsCount = null;
    private Integer m_primitiveArcCount = null;

    Header(RrdDb parentDb, RrdDef rrdDef) throws IOException {
        boolean shouldInitialize = rrdDef != null;
        this.parentDb = parentDb;
        this.signature = new RrdString(this);
        this.step = new RrdLong(this, true);
        this.dsCount = new RrdInt(this, true);
        this.arcCount = new RrdInt(this, true);
        this.lastUpdateTime = new RrdLong(this);
        if (shouldInitialize) {
            this.signature.set(DEFAULT_SIGNATURE);
            this.step.set(rrdDef.getStep());
            this.dsCount.set(rrdDef.getDsCount());
            this.arcCount.set(rrdDef.getArcCount());
            this.lastUpdateTime.set(rrdDef.getStartTime());
        }
    }

    Header(RrdDb parentDb, DataImporter reader) throws IOException, RrdException {
        this(parentDb, (RrdDef)null);
        String version = reader.getVersion();
        int intVersion = Integer.parseInt(version);
        if (intVersion > 3) {
            throw new RrdException("Could not unserialize xml version " + version);
        }
        this.signature.set(DEFAULT_SIGNATURE);
        this.step.set(reader.getStep());
        this.dsCount.set(reader.getDsCount());
        this.arcCount.set(reader.getArcCount());
        this.lastUpdateTime.set(reader.getLastUpdateTime());
    }

    public String getSignature() throws IOException {
        return this.signature.get();
    }

    public String getInfo() throws IOException {
        return this.getSignature().substring(2);
    }

    public void setInfo(String info) throws IOException {
        if (info != null && info.length() > 0) {
            this.signature.set(SIGNATURE + info);
        } else {
            this.signature.set(SIGNATURE);
        }
    }

    public long getLastUpdateTime() throws IOException {
        return this.lastUpdateTime.get();
    }

    public long getStep() throws IOException {
        if (this.m_primitiveStep == null) {
            this.m_primitiveStep = this.step.get();
        }
        return this.m_primitiveStep;
    }

    public int getDsCount() throws IOException {
        if (this.m_primitiveDsCount == null) {
            this.m_primitiveDsCount = this.dsCount.get();
        }
        return this.m_primitiveDsCount;
    }

    public int getArcCount() throws IOException {
        if (this.m_primitiveArcCount == null) {
            this.m_primitiveArcCount = this.arcCount.get();
        }
        return this.m_primitiveArcCount;
    }

    public void setLastUpdateTime(long lastUpdateTime) throws IOException {
        this.lastUpdateTime.set(lastUpdateTime);
    }

    String dump() throws IOException {
        return "== HEADER ==\nsignature:" + this.getSignature() + " lastUpdateTime:" + this.getLastUpdateTime() + " step:" + this.getStep() + " dsCount:" + this.getDsCount() + " arcCount:" + this.getArcCount() + "\n";
    }

    void appendXml(XmlWriter writer) throws IOException {
        writer.writeComment(this.signature.get());
        writer.writeTag("version", RRDTOOL_VERSION);
        writer.writeComment("Seconds");
        writer.writeTag("step", this.step.get());
        writer.writeComment(Util.getDate(this.lastUpdateTime.get()));
        writer.writeTag("lastupdate", this.lastUpdateTime.get());
    }

    @Override
    public void copyStateTo(RrdUpdater other) throws IOException, RrdException {
        if (!(other instanceof Header)) {
            throw new RrdException("Cannot copy Header object to " + other.getClass().getName());
        }
        Header header = (Header)other;
        header.signature.set(this.signature.get());
        header.lastUpdateTime.set(this.lastUpdateTime.get());
    }

    @Override
    public RrdBackend getRrdBackend() {
        return this.parentDb.getRrdBackend();
    }

    boolean isJRobinHeader() throws IOException {
        return this.signature.get().startsWith(SIGNATURE);
    }

    void validateHeader() throws IOException, RrdException {
        if (!this.isJRobinHeader()) {
            throw new RrdException("Invalid file header. File [" + this.parentDb.getCanonicalPath() + "] is not a JRobin RRD file");
        }
    }

    @Override
    public RrdAllocator getRrdAllocator() {
        return this.parentDb.getRrdAllocator();
    }
}

