/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.imp.Reply;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

abstract class Result {
    public static final int ALL_OK = 0;
    public static final int HEUR_HAZARD = 1;
    public static final int HEUR_MIXED = 2;
    public static final int HEUR_ROLLBACK = 3;
    public static final int HEUR_COMMIT = 4;
    public static final int ALL_READONLY = 5;
    public static final int ROLLBACK = 6;
    protected int result_ = -1;
    protected int numberOfMissingReplies_ = 0;
    protected Stack<Reply> replies_ = new Stack();
    protected Hashtable<Participant, Object> repliedlist_ = new Hashtable();
    protected Vector<HeuristicMessage> heuristicMessagesOfNormalParticipants_ = new Vector();
    protected Vector<HeuristicMessage> heuristicMessagesOfHeuristicParticipants_ = new Vector();

    public Result(int numberOfRepliesToWaitFor) {
        this.numberOfMissingReplies_ = numberOfRepliesToWaitFor;
    }

    public int getResult() throws IllegalStateException, InterruptedException {
        this.calculateResultFromAllReplies();
        return this.result_;
    }

    protected synchronized void addMessages(HeuristicMessage[] marr) {
        if (marr == null) {
            return;
        }
        for (int i = 0; i < marr.length; ++i) {
            this.heuristicMessagesOfNormalParticipants_.addElement(marr[i]);
        }
    }

    protected synchronized void addErrorMessages(HeuristicMessage[] marr) {
        if (marr == null) {
            return;
        }
        for (int i = 0; i < marr.length; ++i) {
            this.heuristicMessagesOfHeuristicParticipants_.addElement(marr[i]);
        }
    }

    protected abstract void calculateResultFromAllReplies() throws IllegalStateException, InterruptedException;

    public HeuristicMessage[] getMessages() throws IllegalStateException, InterruptedException {
        this.calculateResultFromAllReplies();
        if (this.heuristicMessagesOfNormalParticipants_.isEmpty()) {
            return null;
        }
        Object[] oarr = this.heuristicMessagesOfNormalParticipants_.toArray();
        HeuristicMessage[] ret = new HeuristicMessage[oarr.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (HeuristicMessage)oarr[i];
        }
        return ret;
    }

    public HeuristicMessage[] getErrorMessages() throws IllegalStateException, InterruptedException {
        this.calculateResultFromAllReplies();
        if (this.heuristicMessagesOfHeuristicParticipants_.isEmpty()) {
            return null;
        }
        Object[] oarr = this.heuristicMessagesOfHeuristicParticipants_.toArray();
        HeuristicMessage[] ret = new HeuristicMessage[oarr.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (HeuristicMessage)oarr[i];
        }
        return ret;
    }

    private boolean ignoreReply(Reply reply) {
        return reply.isRetried() || this.repliedlist_.containsKey(reply.getParticipant());
    }

    public synchronized void addReply(Reply reply) {
        if (!this.ignoreReply(reply)) {
            this.repliedlist_.put(reply.getParticipant(), new Object());
            this.replies_.push(reply);
            --this.numberOfMissingReplies_;
            this.notifyAll();
        }
    }

    public Stack<Reply> getReplies() throws IllegalStateException, InterruptedException {
        this.waitForReplies();
        return this.replies_;
    }

    synchronized void waitForReplies() throws InterruptedException {
        while (this.numberOfMissingReplies_ > 0) {
            this.wait();
        }
    }
}

