/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.crypto.generators;

import java.security.SecureRandom;
import org.opennms.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.opennms.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.opennms.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.X25519PublicKeyParameters;

public class X25519KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        X25519PrivateKeyParameters x25519PrivateKeyParameters = new X25519PrivateKeyParameters(this.random);
        X25519PublicKeyParameters x25519PublicKeyParameters = x25519PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(x25519PublicKeyParameters, x25519PrivateKeyParameters);
    }
}

