/*
 * Decompiled with CFR 0.152.
 */
package jcifs.pac.kerberos;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.security.auth.kerberos.KerberosKey;
import jcifs.pac.ASN1Util;
import jcifs.pac.PACDecodingException;
import jcifs.pac.kerberos.KerberosAuthData;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1InputStream;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Integer;
import org.opennms.shaded.org.bouncycastle.asn1.DEROctetString;
import org.opennms.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.DLSequence;

public class KerberosRelevantAuthData
extends KerberosAuthData {
    private List<KerberosAuthData> authorizations;

    public KerberosRelevantAuthData(byte[] token, Map<Integer, KerberosKey> keys) throws PACDecodingException {
        DLSequence authSequence;
        try (ASN1InputStream stream = new ASN1InputStream(new ByteArrayInputStream(token));){
            authSequence = ASN1Util.as(DLSequence.class, stream);
        }
        catch (IOException e) {
            throw new PACDecodingException("Malformed kerberos ticket", e);
        }
        this.authorizations = new ArrayList<KerberosAuthData>();
        Enumeration authElements = authSequence.getObjects();
        while (authElements.hasMoreElements()) {
            DLSequence authElement = ASN1Util.as(DLSequence.class, authElements);
            ASN1Integer authType = ASN1Util.as(ASN1Integer.class, ASN1Util.as(DERTaggedObject.class, authElement, 0));
            DEROctetString authData = ASN1Util.as(DEROctetString.class, ASN1Util.as(DERTaggedObject.class, authElement, 1));
            this.authorizations.addAll(KerberosAuthData.parse(authType.getValue().intValue(), authData.getOctets(), keys));
        }
    }

    public List<KerberosAuthData> getAuthorizations() {
        return this.authorizations;
    }
}

