/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.opennms.features.topology.api.Point;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.VertexRef;

public class VertexRefPointMapAdapter
extends XmlAdapter<VertexRefPointMap, Map<VertexRef, Point>> {
    public VertexRefPointMap marshal(Map<VertexRef, Point> v) throws Exception {
        if (v == null) {
            return null;
        }
        VertexRefPointMap retval = new VertexRefPointMap();
        for (VertexRef key : v.keySet()) {
            VertexRefPointEntry entry = new VertexRefPointEntry();
            VertexRefKey newKey = new VertexRefKey();
            newKey.namespace = key.getNamespace();
            newKey.id = key.getId();
            newKey.label = key.getLabel();
            Point value = v.get(key);
            PointValue newValue = new PointValue();
            newValue.x = (int)value.getX();
            newValue.y = (int)value.getY();
            entry.key = newKey;
            entry.value = newValue;
            retval.entry.add(entry);
        }
        return retval;
    }

    public Map<VertexRef, Point> unmarshal(VertexRefPointMap v) throws Exception {
        if (v == null) {
            return null;
        }
        HashMap<VertexRef, Point> retval = new HashMap<VertexRef, Point>();
        for (VertexRefPointEntry entry : v.entry) {
            DefaultVertexRef ref = new DefaultVertexRef(entry.key.namespace, entry.key.id, entry.key.label);
            Point point = new Point(entry.value.x, entry.value.y);
            retval.put(ref, point);
        }
        return retval;
    }

    public static final class VertexRefPointMap {
        public List<VertexRefPointEntry> entry = new ArrayList<VertexRefPointEntry>(0);
    }

    public static final class VertexRefPointEntry {
        public VertexRefKey key;
        public PointValue value;
    }

    public static final class VertexRefKey {
        @XmlAttribute
        public String namespace;
        @XmlAttribute
        public String id;
        @XmlAttribute
        public String label;
    }

    public static final class PointValue {
        @XmlAttribute
        public int x;
        @XmlAttribute
        public int y;
    }
}

