/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.browsers;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.BeanItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.Order;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.OnmsContainerDatasource;
import org.opennms.features.topology.api.browsers.SelectionChangedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OnmsVaadinContainer<T, K extends Serializable>
implements Container,
Container.Sortable,
Container.Ordered,
Container.Indexed,
Container.ItemSetChangeNotifier,
SelectionChangedListener {
    private static final long serialVersionUID = -9131723065433979979L;
    protected static final int DEFAULT_PAGE_SIZE = 200;
    private static final Logger LOG = LoggerFactory.getLogger(OnmsVaadinContainer.class);
    private final OnmsContainerDatasource<T, K> m_datasource;
    private final List<Order> m_orders = new ArrayList<Order>();
    private final List<Restriction> m_restrictions = new ArrayList<Restriction>();
    private final List<SortEntry> m_sortEntries = new ArrayList<SortEntry>();
    private final Collection<Container.ItemSetChangeListener> m_itemSetChangeListeners = new HashSet<Container.ItemSetChangeListener>();
    private final Map<String, String> m_beanToHibernatePropertyMapping = new HashMap<String, String>();
    private final Size size;
    private final Page page;
    private final Cache cache;
    private final Class<T> m_itemClass;
    private Map<Object, Class<?>> m_properties;

    public OnmsVaadinContainer(Class<T> itemClass, OnmsContainerDatasource<T, K> datasource) {
        this.m_itemClass = Objects.requireNonNull(itemClass);
        this.m_datasource = Objects.requireNonNull(datasource);
        this.size = new Size(new SizeReloadStrategy(){

            @Override
            public int reload() {
                return OnmsVaadinContainer.this.m_datasource.countMatching(OnmsVaadinContainer.this.getCriteria(null, false));
            }
        });
        this.page = new Page(200, this.size);
        this.cache = new Cache();
    }

    public boolean containsId(Object itemId) {
        if (itemId == null) {
            return false;
        }
        if (this.cache.containsItemId((Serializable)itemId)) {
            return true;
        }
        int index = this.indexOfId(itemId);
        return index >= 0;
    }

    public Property<?> getContainerProperty(Object itemId, Object propertyId) {
        Item item = this.getItem(itemId);
        if (item == null) {
            return null;
        }
        return item.getItemProperty(propertyId);
    }

    public Collection<?> getContainerPropertyIds() {
        this.loadPropertiesIfNull();
        this.updateContainerPropertyIds(this.m_properties);
        return Collections.unmodifiableCollection(this.m_properties.keySet());
    }

    public Item getItem(Object itemId) {
        if (itemId == null) {
            return null;
        }
        if (this.cache.containsItemId((Serializable)itemId)) {
            return this.cache.getItem((Serializable)itemId);
        }
        int index = this.indexOfId(itemId);
        if (index == -1) {
            return null;
        }
        return this.cache.getItem((Serializable)itemId);
    }

    public Class<T> getItemClass() {
        return this.m_itemClass;
    }

    protected abstract K getId(T var1);

    public Class<?> getType(Object propertyId) {
        return this.m_properties.get(propertyId);
    }

    public boolean removeAllItems() throws UnsupportedOperationException {
        this.m_datasource.clear();
        return true;
    }

    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        this.m_datasource.delete((Serializable)itemId);
        return true;
    }

    public int size() {
        return this.size.getValue();
    }

    public Object firstItemId() {
        if (!this.cache.containsIndex(0)) {
            this.updatePage(0);
        }
        return this.cache.getItemId(0);
    }

    public Object lastItemId() {
        int lastIndex = this.size() - 1;
        if (!this.cache.containsIndex(lastIndex)) {
            this.updatePage(lastIndex);
        }
        return this.cache.getItemId(lastIndex);
    }

    public boolean isFirstId(Object itemId) {
        return this.firstItemId().equals(itemId);
    }

    private void updatePage(int index) {
        boolean changed = this.page.updateOffset(index);
        if (changed) {
            this.cache.reload(this.page);
        }
    }

    public boolean isLastId(Object itemId) {
        return this.lastItemId().equals(itemId);
    }

    public Object nextItemId(Object itemId) {
        if (itemId == null) {
            return null;
        }
        int nextIdIndex = this.indexOfId(itemId) + 1;
        if (this.cache.getItemId(nextIdIndex) == null) {
            this.updatePage(this.page.offset + this.page.length);
        }
        return this.cache.getItemId(nextIdIndex);
    }

    public Object prevItemId(Object itemId) {
        if (itemId == null) {
            return null;
        }
        int prevIdIndex = this.indexOfId(itemId) - 1;
        if (this.cache.getItemId(prevIdIndex) == null) {
            this.updatePage(prevIdIndex);
        }
        return this.cache.getItemId(prevIdIndex);
    }

    public Collection<?> getSortableContainerPropertyIds() {
        return this.getContainerPropertyIds();
    }

    public void sort(Object[] propertyId, boolean[] ascending) {
        List<SortEntry> newSortEntries = this.createSortEntries(propertyId, ascending);
        if (!this.m_sortEntries.equals(newSortEntries)) {
            this.m_sortEntries.clear();
            this.m_sortEntries.addAll(newSortEntries);
            this.m_orders.clear();
            for (int i = 0; i < propertyId.length; ++i) {
                String beanProperty = (String)propertyId[i];
                String hibernateProperty = this.m_beanToHibernatePropertyMapping.get(beanProperty);
                if (hibernateProperty == null) {
                    hibernateProperty = beanProperty;
                }
                if (ascending[i]) {
                    this.m_orders.add(Order.asc((String)hibernateProperty));
                    continue;
                }
                this.m_orders.add(Order.desc((String)hibernateProperty));
            }
            this.cache.reload(this.page);
        }
    }

    protected List<SortEntry> createSortEntries(Object[] propertyId, boolean[] ascending) {
        ArrayList<SortEntry> sortEntries = new ArrayList<SortEntry>();
        for (int i = 0; i < propertyId.length; ++i) {
            sortEntries.add(new SortEntry((String)propertyId[i], ascending[i]));
        }
        return sortEntries;
    }

    public void addListener(Container.ItemSetChangeListener listener) {
        this.addItemSetChangeListener(listener);
    }

    public void removeListener(Container.ItemSetChangeListener listener) {
        this.removeItemSetChangeListener(listener);
    }

    public void addItemSetChangeListener(Container.ItemSetChangeListener listener) {
        this.m_itemSetChangeListeners.add(listener);
    }

    public void removeItemSetChangeListener(Container.ItemSetChangeListener listener) {
        this.m_itemSetChangeListeners.remove(listener);
    }

    protected void fireItemSetChangedEvent() {
        Container.ItemSetChangeEvent event = new Container.ItemSetChangeEvent(){
            private static final long serialVersionUID = -2796401359570611938L;

            public Container getContainer() {
                return OnmsVaadinContainer.this;
            }
        };
        for (Container.ItemSetChangeListener listener : this.m_itemSetChangeListeners) {
            listener.containerItemSetChange(event);
        }
    }

    public void setRestrictions(List<Restriction> newRestrictions) {
        if (!this.getRestrictions().equals(newRestrictions)) {
            this.m_restrictions.clear();
            if (newRestrictions != null) {
                this.m_restrictions.addAll(newRestrictions);
            }
            this.getCache().reload(this.getPage());
            this.fireItemSetChangedEvent();
        }
    }

    public List<Restriction> getRestrictions() {
        return Collections.unmodifiableList(this.m_restrictions);
    }

    public void addBeanToHibernatePropertyMapping(String key, String value) {
        this.m_beanToHibernatePropertyMapping.put(key, value);
    }

    public Collection<?> getItemIds() {
        return this.getItemIds(0, this.size());
    }

    public List<K> getItemIds(int startIndex, int numberOfItems) {
        int endIndex;
        boolean needsReload;
        boolean bl = needsReload = !this.cache.containsIndex(startIndex) || !this.cache.containsIndex(startIndex + numberOfItems - 1);
        if (needsReload) {
            this.page.updateOffset(startIndex);
            this.cache.reload(this.page);
            this.fireItemSetChangedEvent();
        }
        if ((endIndex = startIndex + numberOfItems) > this.size()) {
            endIndex = this.size() - 1;
        }
        ArrayList<Object> itemIds = new ArrayList<Object>();
        for (int i = startIndex; i < endIndex; ++i) {
            itemIds.add(this.getIdByIndex(i));
        }
        if (itemIds.size() != numberOfItems) {
            LOG.warn("The container is supposed to carry {} but contains {} item. Expected itemIds: {}. Actual items: {}. Executed Criteria: {}. Bailing.", new Object[]{numberOfItems, itemIds.size(), itemIds, this.getItemsForCache(this.m_datasource, this.getPage()), this.getCriteria(this.getPage(), true)});
            throw new IllegalStateException("The container is supposed to carry " + numberOfItems + " but only contains " + itemIds.size() + " items.");
        }
        return itemIds;
    }

    public int indexOfId(Object itemId) {
        if (this.cache.containsItemId((Serializable)itemId)) {
            return this.cache.getIndex((Serializable)itemId);
        }
        boolean circled = false;
        int startOffset = this.page.offset;
        do {
            int indexOfId;
            if ((indexOfId = this.page.offset + this.page.length) > this.size()) {
                indexOfId = 0;
            }
            this.updatePage(indexOfId);
            if (this.cache.containsItemId((Serializable)itemId)) {
                return this.cache.getIndex((Serializable)itemId);
            }
            if (startOffset != indexOfId) continue;
            circled = true;
        } while (!circled);
        return -1;
    }

    public K getIdByIndex(int index) {
        if (this.cache.containsIndex(index)) {
            return this.cache.getItemId(index);
        }
        this.updatePage(index);
        return this.cache.getItemId(index);
    }

    public Object addItemAt(int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add new items to this container");
    }

    public Item addItemAt(int index, Object newItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add new items to this container");
    }

    public Object addItemAfter(Object previousItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add new items to this container");
    }

    public Item addItemAfter(Object previousItemId, Object newItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add new items to this container");
    }

    public final boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add new properties to objects in this container");
    }

    public Object addItem() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add new items to this container");
    }

    public Item addItem(Object itemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add new items to this container");
    }

    public final boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove properties from objects in this container");
    }

    @Override
    public void selectionChanged(SelectionChangedListener.Selection newSelection) {
        if (newSelection != null) {
            this.setRestrictions(newSelection.toRestrictions());
        }
    }

    protected void updateContainerPropertyIds(Map<Object, Class<?>> properties) {
    }

    protected Criteria getCriteria(Page page, boolean doOrder) {
        Criteria tmpCriteria = new Criteria(this.getItemClass());
        for (Restriction eachRestriction : this.m_restrictions) {
            tmpCriteria.addRestriction(eachRestriction);
        }
        if (doOrder) {
            tmpCriteria.setOrders(this.m_orders);
        }
        if (page != null) {
            tmpCriteria.setOffset(Integer.valueOf(page.offset));
            tmpCriteria.setLimit(Integer.valueOf(page.length));
        }
        this.addAdditionalCriteriaOptions(tmpCriteria, page, doOrder);
        LOG.debug("query criteria: {}", (Object)tmpCriteria);
        return tmpCriteria;
    }

    protected void addAdditionalCriteriaOptions(Criteria criteria, Page page, boolean doOrder) {
    }

    protected List<T> getItemsForCache(OnmsContainerDatasource<T, K> datasource, Page page) {
        return datasource.findMatching(this.getCriteria(page, true));
    }

    protected Cache getCache() {
        return this.cache;
    }

    protected Page getPage() {
        return this.page;
    }

    protected abstract ContentType getContentType();

    private synchronized void loadPropertiesIfNull() {
        if (this.m_properties == null) {
            this.m_properties = new TreeMap();
            BeanItem item = null;
            try {
                item = new BeanItem(this.m_datasource.createInstance(this.m_itemClass));
            }
            catch (IllegalAccessException | InstantiationException e) {
                LoggerFactory.getLogger(this.getClass()).error("Class {} does not have a valid constructor. Cannot create an instance.", this.getItemClass());
            }
            if (item != null) {
                for (Object key : item.getItemPropertyIds()) {
                    this.m_properties.put(key, item.getItemProperty(key).getType());
                }
            }
        }
    }

    protected static class Size {
        private int value;
        private final SizeReloadStrategy reloadStrategy;

        protected Size(SizeReloadStrategy reloadStrategy) {
            this.reloadStrategy = reloadStrategy;
        }

        public synchronized int getValue() {
            this.reloadSize();
            return this.value;
        }

        private synchronized void reloadSize() {
            this.value = this.reloadStrategy.reload();
        }
    }

    protected static interface SizeReloadStrategy {
        public int reload();
    }

    protected static class Page {
        protected int length;
        protected int offset;
        protected final Size size;

        public Page(int length, Size size) {
            this.length = length;
            this.size = size;
        }

        public boolean updateOffset(int index) {
            int oldOffset = this.offset;
            if (index < 0) {
                index = 0;
            }
            this.offset = index / this.length * this.length;
            return oldOffset != this.offset;
        }

        public int getStart() {
            return this.offset;
        }
    }

    protected class Cache {
        private Map<K, BeanItem<T>> cacheContent = new HashMap();
        private Map<Integer, K> rowMap = new HashMap();

        private Cache() {
        }

        public boolean containsItemId(K itemId) {
            if (itemId == null) {
                return false;
            }
            return this.cacheContent.containsKey(itemId);
        }

        public boolean containsIndex(int index) {
            return this.rowMap.containsKey(index);
        }

        public BeanItem<T> getItem(K itemId) {
            if (this.containsItemId(itemId)) {
                return this.cacheContent.get(itemId);
            }
            return null;
        }

        public void addItem(int rowNumber, K itemId, T bean) {
            if (this.containsItemId(itemId)) {
                return;
            }
            this.cacheContent.put(itemId, new BeanItem(bean));
            this.rowMap.put(rowNumber, (Integer)itemId);
        }

        public int getIndex(K itemId) {
            for (Map.Entry eachRow : this.rowMap.entrySet()) {
                if (!((Serializable)eachRow.getValue()).equals(itemId)) continue;
                return eachRow.getKey();
            }
            return -1;
        }

        public void reset() {
            this.cacheContent.clear();
            this.rowMap.clear();
        }

        public K getItemId(int rowIndex) {
            return (Serializable)this.rowMap.get(rowIndex);
        }

        public void reload(Page page) {
            this.reset();
            List beans = OnmsVaadinContainer.this.getItemsForCache(OnmsVaadinContainer.this.m_datasource, page);
            if (beans == null) {
                return;
            }
            int rowNumber = page.getStart();
            for (Object eachBean : beans) {
                this.addItem(rowNumber, OnmsVaadinContainer.this.getId(eachBean), eachBean);
                ++rowNumber;
            }
            if (beans.size() != this.rowMap.size()) {
                throw new IllegalStateException("The cache is supposed to carry " + beans.size() + " but contains " + this.rowMap.size() + " items.");
            }
        }
    }

    protected static class SortEntry
    implements Comparable<SortEntry> {
        private final String propertyId;
        private final boolean ascending;

        private SortEntry(String propertyId, boolean ascending) {
            this.propertyId = propertyId;
            this.ascending = ascending;
        }

        @Override
        public int compareTo(SortEntry o) {
            return this.propertyId.compareTo(o.propertyId);
        }
    }
}

