/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api;

import java.awt.geom.Point2D;
import org.opennms.features.topology.api.Point;

public class DblBoundingBox {
    private double m_left = Double.MAX_VALUE;
    private double m_top = Double.MAX_VALUE;
    private double m_right = Double.MIN_VALUE;
    private double m_bottom = Double.MIN_VALUE;

    public DblBoundingBox() {
    }

    public DblBoundingBox(DblBoundingBox box) {
        this.m_left = box.m_left;
        this.m_right = box.m_right;
        this.m_top = box.m_top;
        this.m_bottom = box.m_bottom;
    }

    public DblBoundingBox(double x, double y, double width, double height) {
        this.m_left = x;
        this.m_top = y;
        this.m_right = x + width;
        this.m_bottom = y + height;
    }

    public DblBoundingBox(Point2D center, double width, double height) {
        this.m_left = center.getX() - width / 2.0;
        this.m_top = center.getY() - height / 2.0;
        this.m_right = this.m_left + width;
        this.m_bottom = this.m_top + height;
    }

    public double getX() {
        return this.m_left;
    }

    public double getY() {
        return this.m_top;
    }

    public double getWidth() {
        return this.m_right - this.m_left;
    }

    public double getHeight() {
        return this.m_bottom - this.m_top;
    }

    public void addPoint(Point2D location) {
        this.m_left = Math.min(this.m_left, location.getX());
        this.m_right = Math.max(this.m_right, location.getX());
        this.m_top = Math.min(this.m_top, location.getY());
        this.m_bottom = Math.max(this.m_bottom, location.getY());
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.getX() + this.getWidth() / 2.0, this.getY() + this.getHeight() / 2.0);
    }

    public void setCenter(Point center) {
        this.m_left = center.getX() - this.getWidth() / 2.0;
        this.m_top = center.getY() - this.getHeight() / 2.0;
    }

    public DblBoundingBox computeWithAspectRatio(double R) {
        double r = this.getAspectRatio();
        double width = r < R ? (double)Math.round(this.getHeight() * R) : this.getWidth();
        double height = r < R ? this.getHeight() : (double)Math.round(this.getWidth() / R);
        Point2D center = this.getCenter();
        return new DblBoundingBox(center, width, height);
    }

    private double getAspectRatio() {
        return this.getHeight() == 0.0 ? 0.0 : this.getWidth() / this.getHeight();
    }

    public String toString() {
        return "x: " + this.getX() + " y: " + this.getY() + " width: " + this.getWidth() + " height: " + this.getHeight();
    }

    public String fragment() {
        return "(" + this.getX() + "," + this.getY() + "," + this.getWidth() + "," + this.getHeight() + ")";
    }

    public void addBoundingbox(DblBoundingBox box) {
        this.m_left = Math.min(this.m_left, box.m_left);
        this.m_right = Math.max(this.m_right, box.m_right);
        this.m_top = Math.min(this.m_top, box.m_top);
        this.m_bottom = Math.max(this.m_bottom, box.m_bottom);
    }

    public int hashCode() {
        int prime = 31;
        double result = 1.0;
        result = 31.0 * result + this.m_bottom;
        result = 31.0 * result + this.m_left;
        result = 31.0 * result + this.m_right;
        result = 31.0 * result + this.m_top;
        return Double.valueOf(result).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DblBoundingBox other = (DblBoundingBox)obj;
        if (this.m_bottom != other.m_bottom) {
            return false;
        }
        if (this.m_left != other.m_left) {
            return false;
        }
        if (this.m_right != other.m_right) {
            return false;
        }
        return this.m_top == other.m_top;
    }
}

