/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.scv.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Credentials
implements Serializable {
    static final long serialVersionUID = -1241293670886186178L;
    private final String m_username;
    private final String m_password;
    private final Map<String, String> m_attributes;

    public Credentials(String username, String password) {
        this(username, password, Collections.emptyMap());
    }

    public Credentials(String username, String password, Map<String, String> attributes) {
        this.m_username = username;
        this.m_password = password;
        this.m_attributes = attributes == null ? Collections.unmodifiableMap(Collections.emptyMap()) : Collections.unmodifiableMap(Objects.requireNonNull(attributes));
    }

    public String getUsername() {
        return this.m_username;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getAttribute(String key) {
        return this.m_attributes.get(key);
    }

    public Set<String> getAttributeKeys() {
        return this.m_attributes.keySet();
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.m_attributes);
    }

    public int hashCode() {
        return Objects.hash(this.m_attributes, this.m_password, this.m_username);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Credentials other = (Credentials)obj;
        return Objects.equals(this.m_attributes, other.m_attributes) && Objects.equals(this.m_password, other.m_password) && Objects.equals(this.m_username, other.m_username);
    }

    public String toString() {
        return String.format("Credentials[username=%s,password=XXXXXX]", this.m_username);
    }
}

