/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import com.google.common.collect.Table;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.common.TopologyUpdater;
import org.opennms.netmgt.enlinkd.model.IpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.model.SnmpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.enlinkd.service.api.SubNetwork;
import org.opennms.netmgt.enlinkd.service.api.Topology;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyPort;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;

public class NetworkRouterTopologyUpdater
extends TopologyUpdater {
    public static OnmsTopologyPort create(OnmsTopologyVertex source, IpInterfaceTopologyEntity sourceAddr, SnmpInterfaceTopologyEntity snmpiface) {
        OnmsTopologyPort port = OnmsTopologyPort.create((String)sourceAddr.getIpAddress().getHostAddress(), (OnmsTopologyVertex)source, (Integer)sourceAddr.getId());
        if (snmpiface != null) {
            port.setIfindex(snmpiface.getIfIndex());
            port.setIfname(snmpiface.getIfName());
        }
        port.setAddr(sourceAddr.getIpAddress().getHostAddress());
        port.setToolTipText(Topology.getPortTextString((String)source.getLabel(), (Integer)port.getIndex(), (String)port.getAddr(), (SnmpInterfaceTopologyEntity)snmpiface));
        return port;
    }

    public static OnmsTopologyPort createNetworkPort(OnmsTopologyVertex source, IpInterfaceTopologyEntity target) {
        OnmsTopologyPort port = OnmsTopologyPort.create((String)(source.getId() + "to:" + target.getIpAddress().getHostAddress()), (OnmsTopologyVertex)source, (Integer)target.getId());
        port.setAddr("to: " + target.getIpAddress().getHostAddress());
        port.setToolTipText(Topology.getPortTextString((String)source.getLabel(), null, (String)port.getAddr(), null));
        return port;
    }

    public static OnmsTopologyVertex createNetworkVertex(SubNetwork network) {
        OnmsTopologyVertex networkVertex = OnmsTopologyVertex.create((String)network.getCidr(), (String)network.getCidr(), (String)network.getCidr(), (String)Topology.getCloudIconKey());
        networkVertex.setToolTipText("SubNetwork: " + network.getCidr() + ", Nodeids:" + network.getNodeIds());
        return networkVertex;
    }

    public NetworkRouterTopologyUpdater(OnmsTopologyDao topologyDao, NodeTopologyService nodeTopologyService) {
        super((TopologyService)nodeTopologyService, topologyDao, nodeTopologyService);
    }

    public String getName() {
        return "NetworkRouterTopologyUpdater";
    }

    public OnmsTopology buildTopology() {
        OnmsTopology topology = new OnmsTopology();
        Map ipPrimaryMap = this.getIpPrimaryMap();
        this.getNodeMap().values().forEach(element -> topology.getVertices().add(NetworkRouterTopologyUpdater.create((NodeTopologyEntity)element, (IpInterfaceTopologyEntity)((IpInterfaceTopologyEntity)ipPrimaryMap.get(element.getId())))));
        Table ipTable = this.getIpInterfaceTable();
        Map snmpMap = this.getSnmpInterfaceMap();
        this.getNodeTopologyService().findAllLegalPointToPointSubNetwork().forEach(subnet -> {
            Iterator nodeiterator = subnet.getNodeIds().iterator();
            Integer sourceNodeid = (Integer)nodeiterator.next();
            Integer targetNodeid = (Integer)nodeiterator.next();
            OnmsTopologyVertex source = topology.getVertex(sourceNodeid.toString());
            OnmsTopologyVertex target = topology.getVertex(targetNodeid.toString());
            IpInterfaceTopologyEntity sourceIp = null;
            IpInterfaceTopologyEntity targetIp = null;
            for (InetAddress inet : ipTable.row((Object)sourceNodeid).keySet()) {
                if (!InetAddressUtils.inSameNetwork((InetAddress)inet, (InetAddress)subnet.getNetwork(), (InetAddress)subnet.getNetmask())) continue;
                sourceIp = (IpInterfaceTopologyEntity)ipTable.get((Object)sourceNodeid, (Object)inet);
                break;
            }
            for (InetAddress inet : ipTable.row((Object)targetNodeid).keySet()) {
                if (!InetAddressUtils.inSameNetwork((InetAddress)inet, (InetAddress)subnet.getNetwork(), (InetAddress)subnet.getNetmask())) continue;
                targetIp = (IpInterfaceTopologyEntity)ipTable.get((Object)targetNodeid, (Object)inet);
                break;
            }
            if (sourceIp == null || targetIp == null) {
                return;
            }
            OnmsTopologyPort sourcePort = NetworkRouterTopologyUpdater.create(source, sourceIp, sourceIp.getSnmpInterfaceId() != null ? (SnmpInterfaceTopologyEntity)snmpMap.get(sourceIp.getSnmpInterfaceId()) : null);
            OnmsTopologyPort targetPort = NetworkRouterTopologyUpdater.create(target, targetIp, targetIp.getSnmpInterfaceId() != null ? (SnmpInterfaceTopologyEntity)snmpMap.get(targetIp.getSnmpInterfaceId()) : null);
            topology.getEdges().add(OnmsTopologyEdge.create((String)sourceIp.getId().toString(), (OnmsTopologyPort)sourcePort, (OnmsTopologyPort)targetPort));
        });
        this.getNodeTopologyService().findSubNetworkByNetworkPrefixLessThen(30, 126).forEach(subnet -> {
            topology.getVertices().add(NetworkRouterTopologyUpdater.createNetworkVertex(subnet));
            OnmsTopologyVertex source = topology.getVertex(subnet.getCidr());
            for (Integer targetNodeid : subnet.getNodeIds()) {
                OnmsTopologyVertex target = topology.getVertex(targetNodeid.toString());
                IpInterfaceTopologyEntity targetIp = null;
                for (InetAddress inet : ipTable.row((Object)targetNodeid).keySet()) {
                    if (!InetAddressUtils.inSameNetwork((InetAddress)inet, (InetAddress)subnet.getNetwork(), (InetAddress)subnet.getNetmask())) continue;
                    targetIp = (IpInterfaceTopologyEntity)ipTable.get((Object)targetNodeid, (Object)inet);
                    break;
                }
                if (targetIp == null) {
                    return;
                }
                OnmsTopologyPort sourcePort = NetworkRouterTopologyUpdater.createNetworkPort(source, targetIp);
                OnmsTopologyPort targetPort = NetworkRouterTopologyUpdater.create(target, targetIp, targetIp.getSnmpInterfaceId() != null ? (SnmpInterfaceTopologyEntity)snmpMap.get(targetIp.getSnmpInterfaceId()) : null);
                topology.getEdges().add(OnmsTopologyEdge.create((String)targetIp.getId().toString(), (OnmsTopologyPort)sourcePort, (OnmsTopologyPort)targetPort));
            }
        });
        NodeTopologyEntity defaultFocusPoint = this.getDefaultFocusPoint();
        if (defaultFocusPoint != null) {
            topology.setDefaultVertex(NetworkRouterTopologyUpdater.create((NodeTopologyEntity)defaultFocusPoint, (IpInterfaceTopologyEntity)((IpInterfaceTopologyEntity)ipPrimaryMap.get(defaultFocusPoint.getId()))));
        }
        return topology;
    }

    public OnmsTopologyProtocol getProtocol() {
        return NetworkRouterTopologyUpdater.create((ProtocolSupported)ProtocolSupported.NETWORKROUTER);
    }
}

