/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.config.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.opennms.core.config.api.ConfigurationResource;
import org.opennms.core.config.api.ConfigurationResourceException;
import org.opennms.core.xml.JaxbUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;

public class JaxbResourceConfiguration<T>
implements ConfigurationResource<T> {
    private Class<T> m_class;
    private Resource m_resource;

    public JaxbResourceConfiguration(Class<T> clazz, Resource resource) {
        this.m_class = clazz;
        this.m_resource = resource;
    }

    protected Class<T> getClassType() {
        return this.m_class;
    }

    protected Resource getResource() {
        return this.m_resource;
    }

    public T get() throws ConfigurationResourceException {
        Class<T> classType = this.getClassType();
        Resource resource = this.getResource();
        try {
            return (T)JaxbUtils.unmarshal(classType, (Resource)resource);
        }
        catch (Exception e) {
            throw new ConfigurationResourceException("Failed to unmarshal " + resource + " to class " + classType, (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(T config) throws ConfigurationResourceException {
        Resource r = this.getResource();
        if (!(r instanceof WritableResource)) {
            throw new ConfigurationResourceException("Resource " + r + " is not writable!");
        }
        WritableResource resource = (WritableResource)r;
        OutputStream os = null;
        OutputStreamWriter osw = null;
        try {
            os = resource.getOutputStream();
            osw = new OutputStreamWriter(os);
            JaxbUtils.marshal(config, (Writer)osw);
        }
        catch (IOException e) {
            try {
                throw new ConfigurationResourceException("Failed to write to " + r, (Throwable)e);
                catch (Exception e2) {
                    throw new ConfigurationResourceException("Failed to marshal configuration " + this.getClassType() + " to resource " + r, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(osw);
                IOUtils.closeQuietly((OutputStream)os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)osw);
        IOUtils.closeQuietly((OutputStream)os);
    }
}

