/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.alarms.history.rest.impl;

import java.util.Collection;
import java.util.Objects;
import org.opennms.features.alarms.history.api.AlarmHistoryRepository;
import org.opennms.features.alarms.history.api.AlarmState;
import org.opennms.features.alarms.history.rest.api.AlarmHistoryRestService;

public class AlarmHistoryRestServiceImpl
implements AlarmHistoryRestService {
    public static final String REDUCTION_KEY_MATCH_TYPE = "reduction-key";
    private final AlarmHistoryRepository alarmHistoryRepository;

    public AlarmHistoryRestServiceImpl(AlarmHistoryRepository alarmHistoryRepository) {
        this.alarmHistoryRepository = Objects.requireNonNull(alarmHistoryRepository);
    }

    public Collection<AlarmState> getStatesForAlarm(String alarmId, String matchType) {
        if (REDUCTION_KEY_MATCH_TYPE.equals(matchType)) {
            return this.alarmHistoryRepository.getStatesForAlarmWithReductionKey(matchType);
        }
        return this.alarmHistoryRepository.getStatesForAlarmWithDbId((long)Integer.valueOf(alarmId).intValue());
    }

    public AlarmState getAlarm(String alarmId, String matchType, Long time) {
        long timestampInMillis;
        long l = timestampInMillis = time == null ? System.currentTimeMillis() : time;
        if (REDUCTION_KEY_MATCH_TYPE.equals(matchType)) {
            return this.alarmHistoryRepository.getAlarmWithReductionKeyIdAt(alarmId, timestampInMillis).orElse(null);
        }
        return this.alarmHistoryRepository.getAlarmWithDbIdAt((long)Integer.valueOf(alarmId).intValue(), timestampInMillis).orElse(null);
    }

    public Collection<AlarmState> getActiveAlarmsAt(Long time) {
        long timestampInMillis = time == null ? System.currentTimeMillis() : time;
        return this.alarmHistoryRepository.getActiveAlarmsAt(timestampInMillis);
    }
}

