/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.invoker.junit.internal;

import org.junit.Ignore;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.ops4j.pax.exam.RerunTestException;
import org.ops4j.pax.exam.util.Injector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerTestRunner.class);
    private Injector injector;

    public ContainerTestRunner(Class<?> klass, Injector injector) throws InitializationError {
        super(klass);
        this.injector = injector;
    }

    protected Object createTest() throws Exception {
        Object test = super.createTest();
        this.injector.injectFields(test);
        return test;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        LOG.info("running {} in reactor", (Object)method.getName());
        this.runChildWithRetry(method, notifier);
    }

    protected void runChildWithRetry(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (method.getAnnotation(Ignore.class) != null) {
            notifier.fireTestIgnored(description);
        } else {
            this.runLeafWithRetry(this.methodBlock(method), description, notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runLeafWithRetry(Statement statement, Description description, RunNotifier notifier) {
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
        eachNotifier.fireTestStarted();
        boolean retry = false;
        try {
            statement.evaluate();
        }
        catch (AssumptionViolatedException e) {
            eachNotifier.addFailedAssumption(e);
        }
        catch (RerunTestException e) {
            retry = true;
            throw e;
        }
        catch (Throwable t) {
            eachNotifier.addFailure(t);
        }
        finally {
            if (!retry) {
                eachNotifier.fireTestFinished();
            }
        }
    }
}

