/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.config.ui;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.validator.AbstractStringValidator;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.features.vaadin.dashboard.config.DashletSelector;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardConfigUI;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardEditor;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardOverview;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardProvider;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardTabSheet;
import org.opennms.features.vaadin.dashboard.model.DashletFactory;
import org.opennms.features.vaadin.dashboard.model.Wallboard;

public class WallboardConfigView
extends HorizontalLayout
implements TabSheet.CloseHandler,
DashletSelector.ServiceListChangedListener {
    private WallboardTabSheet m_tabSheet;
    private DashletSelector m_dashletSelector;
    private Map<Wallboard, TabSheet.Tab> m_wallboardEditorMap = new HashMap<Wallboard, TabSheet.Tab>();
    private WallboardOverview m_dashboardOverview;

    public WallboardConfigView(DashletSelector dashletSelector) {
        this.m_dashletSelector = dashletSelector;
        this.setSizeFull();
        this.m_tabSheet = new WallboardTabSheet(){

            @Override
            protected void addNewTabComponent() {
                WallboardConfigView.this.addNewTabComponent();
            }
        };
        this.m_tabSheet.setSizeFull();
        this.m_dashboardOverview = new WallboardOverview(this);
        TabSheet.Tab overviewTab = this.m_tabSheet.addTab((Component)this.m_dashboardOverview, "Overview");
        overviewTab.setClosable(false);
        this.m_tabSheet.setSelectedTab(overviewTab);
        this.m_tabSheet.setCloseHandler(this);
        this.addComponent((Component)this.m_tabSheet);
        dashletSelector.addServiceListChangedListener(this);
        WallboardProvider.getInstance().getBeanContainer().addItemSetChangeListener(new Container.ItemSetChangeListener(){

            public void containerItemSetChange(Container.ItemSetChangeEvent itemSetChangeEvent) {
                ArrayList<Wallboard> wallboardsToRemove = new ArrayList<Wallboard>();
                ArrayList<TabSheet.Tab> tabsToRemove = new ArrayList<TabSheet.Tab>();
                for (Map.Entry entry : WallboardConfigView.this.m_wallboardEditorMap.entrySet()) {
                    WallboardEditor wallboardEditor = (WallboardEditor)((TabSheet.Tab)entry.getValue()).getComponent();
                    if (WallboardProvider.getInstance().containsWallboard(wallboardEditor.getWallboard())) continue;
                    wallboardsToRemove.add(wallboardEditor.getWallboard());
                    tabsToRemove.add((TabSheet.Tab)entry.getValue());
                }
                for (TabSheet.Tab tab : tabsToRemove) {
                    WallboardConfigView.this.m_tabSheet.removeTab(tab);
                }
                for (Wallboard wallboard : wallboardsToRemove) {
                    WallboardConfigView.this.m_wallboardEditorMap.remove(wallboard);
                }
            }
        });
    }

    public void openWallboardEditor(Wallboard wallboard) {
        if (this.m_wallboardEditorMap.containsKey(wallboard)) {
            this.m_tabSheet.setSelectedTab(this.m_wallboardEditorMap.get(wallboard));
        } else {
            WallboardEditor wallboardEditor = new WallboardEditor(this.m_dashletSelector, wallboard);
            TabSheet.Tab tab = this.m_tabSheet.addTab((Component)wallboardEditor, wallboard.getTitle(), null);
            wallboardEditor.setTab(tab);
            tab.setClosable(true);
            this.m_wallboardEditorMap.put(wallboard, tab);
            this.m_tabSheet.setSelectedTab(tab);
        }
    }

    public void removeTab(String name) {
        for (int i = 0; i < this.m_tabSheet.getComponentCount(); ++i) {
            TabSheet.Tab tab = this.m_tabSheet.getTab(i);
            if (!name.equals(tab.getCaption())) continue;
            this.m_tabSheet.removeTab(tab);
        }
    }

    protected void addNewTabComponent() {
        final Window window = new Window("New Ops Board");
        window.setModal(true);
        window.setClosable(false);
        window.setResizable(false);
        window.addCloseListener(new Window.CloseListener(){

            public void windowClose(Window.CloseEvent e) {
                WallboardConfigView.this.m_dashboardOverview.refreshTable();
            }
        });
        this.getUI().addWindow(window);
        window.setContent((Component)new VerticalLayout(){
            TextField name = new TextField("Ops Board Name");
            {
                this.addComponent((Component)new FormLayout(){
                    {
                        this.setSizeUndefined();
                        this.setMargin(true);
                        String newName = "Untitled";
                        int i = 1;
                        if (WallboardProvider.getInstance().containsWallboard(newName)) {
                            do {
                                newName = "Untitled #" + ++i;
                            } while (WallboardProvider.getInstance().containsWallboard(newName));
                        }
                        name.setId("newopsboard.name");
                        name.setValue(newName);
                        this.addComponent((Component)name);
                        name.focus();
                        name.selectAll();
                        name.addValidator((Validator)new AbstractStringValidator("Title must be unique"){

                            protected boolean isValidValue(String s) {
                                return !WallboardProvider.getInstance().containsWallboard(s) && !"".equals(s);
                            }
                        });
                    }
                });
                this.addComponent((Component)new HorizontalLayout(){
                    {
                        this.setMargin(true);
                        this.setSpacing(true);
                        this.setWidth("100%");
                        Button cancel = new Button("Cancel");
                        cancel.setDescription("Cancel editing");
                        cancel.addClickListener(new Button.ClickListener(){

                            public void buttonClick(Button.ClickEvent event) {
                                WallboardConfigView.this.m_tabSheet.togglePlusTab();
                                window.close();
                            }
                        });
                        cancel.setClickShortcut(27, null);
                        this.addComponent((Component)cancel);
                        this.setExpandRatio((Component)cancel, 1.0f);
                        this.setComponentAlignment((Component)cancel, Alignment.TOP_RIGHT);
                        Button ok = new Button("Save");
                        ok.setId("newopsboard.save");
                        ok.setDescription("Save configuration");
                        ok.addClickListener(new Button.ClickListener(){

                            public void buttonClick(Button.ClickEvent event) {
                                if (name.isValid()) {
                                    Wallboard wallboard = new Wallboard();
                                    wallboard.setTitle((String)name.getValue());
                                    WallboardProvider.getInstance().addWallboard(wallboard);
                                    WallboardProvider.getInstance().save();
                                    WallboardEditor wallboardEditor = new WallboardEditor(WallboardConfigView.this.m_dashletSelector, wallboard);
                                    TabSheet.Tab tab = WallboardConfigView.this.m_tabSheet.addTab((Component)wallboardEditor, wallboard.getTitle());
                                    wallboardEditor.setTab(tab);
                                    WallboardConfigView.this.m_wallboardEditorMap.put(wallboard, tab);
                                    tab.setClosable(true);
                                    WallboardConfigView.this.m_tabSheet.setSelectedTab(tab);
                                    window.close();
                                }
                            }
                        });
                        ok.setClickShortcut(13, null);
                        this.addComponent((Component)ok);
                    }
                });
            }
        });
    }

    @Override
    public void serviceListChanged(List<DashletFactory> factoryList) {
        for (Map.Entry<Wallboard, TabSheet.Tab> entry : this.m_wallboardEditorMap.entrySet()) {
            WallboardEditor wallboardEditor = (WallboardEditor)entry.getValue().getComponent();
            wallboardEditor.updateServiceList(factoryList);
        }
        ((WallboardConfigUI)this.getUI()).notifyMessage("Configuration change", "Dashlet list modified");
    }

    public void onTabClose(TabSheet tabsheet, Component tabContent) {
        tabsheet.setSelectedTab(0);
        tabsheet.removeComponent(tabContent);
        this.m_wallboardEditorMap.remove(((WallboardEditor)tabContent).getWallboard());
    }

    public DashletSelector getDashletSelector() {
        return this.m_dashletSelector;
    }
}

