/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.zenithconnect.persistence.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.time.Instant;
import java.util.UUID;
import org.opennms.features.distributed.kvstore.api.JsonStore;
import org.opennms.features.zenithconnect.persistence.api.ZenithConnectPersistenceException;
import org.opennms.features.zenithconnect.persistence.api.ZenithConnectPersistenceService;
import org.opennms.features.zenithconnect.persistence.api.ZenithConnectRegistration;
import org.opennms.features.zenithconnect.persistence.api.ZenithConnectRegistrations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZenithConnectPersistenceServiceImpl
implements ZenithConnectPersistenceService {
    private static final Logger LOG = LoggerFactory.getLogger(ZenithConnectPersistenceServiceImpl.class);
    private static final String ZENITH_CONNECT_CONTEXT = "ZENITH_CONNECT";
    private static final String ZENITH_CONNECT_REGISTRATIONS_KEY = "registrations";
    private final JsonStore jsonStore;

    public ZenithConnectPersistenceServiceImpl(JsonStore jsonStore) {
        this.jsonStore = jsonStore;
    }

    @Override
    public ZenithConnectRegistrations getRegistrations() throws ZenithConnectPersistenceException {
        return this.getRegistrationsImpl();
    }

    @Override
    public ZenithConnectRegistration addRegistration(ZenithConnectRegistration registration, boolean preventDuplicates) throws ZenithConnectPersistenceException {
        if (preventDuplicates && this.isDuplicateRegistration(registration)) {
            throw new ZenithConnectPersistenceException(true);
        }
        registration.id = UUID.randomUUID().toString();
        registration.createTimeMs = Instant.now().toEpochMilli();
        ZenithConnectRegistrations registrations = new ZenithConnectRegistrations(registration);
        this.setRegistrations(registrations);
        return registration;
    }

    @Override
    public ZenithConnectRegistration addRegistration(ZenithConnectRegistration registration) throws ZenithConnectPersistenceException {
        return this.addRegistration(registration, false);
    }

    @Override
    public void updateRegistration(String id, ZenithConnectRegistration registration) throws ZenithConnectPersistenceException {
        if (Strings.isNullOrEmpty((String)id) || Strings.isNullOrEmpty((String)registration.id) || !id.equals(registration.id)) {
            throw new ZenithConnectPersistenceException("Error updating registration, must include valid id.");
        }
        ZenithConnectRegistrations existingRegistrations = this.getRegistrationsImpl();
        ZenithConnectRegistration existingRegistration = existingRegistrations.getRegistrations().stream().filter(r -> r.id.equals(id)).findFirst().orElse(null);
        if (existingRegistration == null) {
            throw new ZenithConnectPersistenceException("Error updating registration, must update existing item.");
        }
        registration.createTimeMs = existingRegistration.createTimeMs;
        ZenithConnectRegistrations newRegistrations = new ZenithConnectRegistrations(registration);
        this.setRegistrations(newRegistrations);
    }

    @Override
    public void deleteRegistration(String id) throws ZenithConnectPersistenceException {
        if (Strings.isNullOrEmpty((String)id)) {
            throw new ZenithConnectPersistenceException("Delete Registration: Invalid or empty id in request.");
        }
        ZenithConnectRegistrations registrations = this.getRegistrationsImpl();
        if (!registrations.getRegistrations().stream().anyMatch(r -> r.id != null && r.id.equals(id))) {
            throw new ZenithConnectPersistenceException("Delete Registration: Invalid id or id not found.");
        }
        this.setRegistrations(new ZenithConnectRegistrations());
    }

    private ZenithConnectRegistrations getRegistrationsImpl() throws ZenithConnectPersistenceException {
        String json = this.jsonStore.get(ZENITH_CONNECT_REGISTRATIONS_KEY, ZENITH_CONNECT_CONTEXT).orElse(null);
        if (json != null) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                ZenithConnectRegistrations registrations = (ZenithConnectRegistrations)objectMapper.readValue(json, ZenithConnectRegistrations.class);
                return registrations;
            }
            catch (Exception e) {
                throw new ZenithConnectPersistenceException("Error deserializing value from json store", e);
            }
        }
        return new ZenithConnectRegistrations();
    }

    private void setRegistrations(ZenithConnectRegistrations registrations) throws ZenithConnectPersistenceException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String registrationsJson = objectMapper.writeValueAsString((Object)registrations);
            this.jsonStore.put(ZENITH_CONNECT_REGISTRATIONS_KEY, (Object)registrationsJson, ZENITH_CONNECT_CONTEXT);
        }
        catch (JsonProcessingException e) {
            throw new ZenithConnectPersistenceException("Could not serialize Zenith Connect registrations", e);
        }
    }

    private boolean isDuplicateRegistration(ZenithConnectRegistration registration) throws ZenithConnectPersistenceException {
        boolean systemIdsMatch;
        ZenithConnectRegistrations existingRegistrations = this.getRegistrationsImpl();
        ZenithConnectRegistration existingRegistration = existingRegistrations.first();
        if (existingRegistration == null) {
            return false;
        }
        boolean bl = systemIdsMatch = registration.systemId != null && existingRegistration.systemId != null && registration.systemId.equals(existingRegistration.systemId);
        if (systemIdsMatch) {
            boolean accessTokenMatches = registration.accessToken != null && existingRegistration.accessToken != null && registration.accessToken.equals(existingRegistration.accessToken);
            boolean refreshTokenMatches = registration.refreshToken != null && existingRegistration.refreshToken != null && registration.refreshToken.equals(existingRegistration.refreshToken);
            return accessTokenMatches || refreshTokenMatches;
        }
        return false;
    }
}

