/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.application.browsers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.InRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.features.topology.api.browsers.ContentType;
import org.opennms.features.topology.api.browsers.OnmsContainerDatasource;
import org.opennms.features.topology.api.browsers.OnmsVaadinContainer;
import org.opennms.features.topology.plugins.topo.application.browsers.ApplicationOutage;
import org.opennms.features.topology.plugins.topo.application.browsers.ApplicationOutageDatasource;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;

public class ApplicationOutageDaoContainer
extends OnmsVaadinContainer<ApplicationOutage, Integer> {
    private static final long serialVersionUID = 1L;
    private ApplicationDao applicationDao;

    public ApplicationOutageDaoContainer(OutageDao dao, ApplicationDao applicationDao) {
        super(ApplicationOutage.class, (OnmsContainerDatasource)new ApplicationOutageDatasource(dao));
        this.applicationDao = applicationDao;
    }

    protected Integer getId(ApplicationOutage bean) {
        return bean == null ? null : Integer.valueOf(bean.getId());
    }

    protected ContentType getContentType() {
        return ContentType.Application;
    }

    protected void addAdditionalCriteriaOptions(Criteria criteria, OnmsVaadinContainer.Page page, boolean doOrder) {
        List applications;
        Collection selectedIds = criteria.getRestrictions().stream().filter(r -> r.getType().equals((Object)Restriction.RestrictionType.IN)).map(r -> ((InRestriction)r).getValues()).flatMap(Collection::stream).map(o -> (Integer)o).collect(Collectors.toList());
        Collection restrictionsWithoutIdFilter = criteria.getRestrictions().stream().filter(r -> !r.getType().equals((Object)Restriction.RestrictionType.IN)).collect(Collectors.toList());
        criteria.setRestrictions(restrictionsWithoutIdFilter);
        criteria.addRestriction((Restriction)Restrictions.isNull((String)"ifRegainedService"));
        criteria.addRestriction((Restriction)Restrictions.isNotNull((String)"perspective"));
        HashSet<OnmsMonitoredService> services = new HashSet<OnmsMonitoredService>();
        if (selectedIds.isEmpty()) {
            applications = Collections.emptyList();
        } else {
            Criteria appCriteria = new CriteriaBuilder(OnmsApplication.class).in("id", selectedIds).toCriteria();
            applications = this.applicationDao.findMatching(appCriteria);
        }
        for (OnmsApplication application : applications) {
            services.addAll(application.getMonitoredServices());
        }
        Iterator<Object> iterator = selectedIds.iterator();
        while (iterator.hasNext()) {
            int serviceId = (Integer)iterator.next();
            OnmsMonitoredService service = new OnmsMonitoredService();
            service.setId(Integer.valueOf(serviceId));
            services.add(service);
        }
        if (services.isEmpty()) {
            criteria.addRestriction((Restriction)Restrictions.sql((String)"1=2"));
        } else {
            criteria.addRestriction((Restriction)Restrictions.in((String)"monitoredService", services));
        }
        criteria.setAliases(Arrays.asList(new Alias("monitoredService.ipInterface.node", "nodeLabel", Alias.JoinType.LEFT_JOIN), new Alias("monitoredService.ipInterface", "ipAddress", Alias.JoinType.LEFT_JOIN), new Alias("monitoredService.serviceType", "serviceName", Alias.JoinType.LEFT_JOIN), new Alias("perspective", "perspective", Alias.JoinType.LEFT_JOIN)));
    }
}

