/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.integration.api.sample.SampleCollector;
import org.opennms.integration.api.v1.collectors.CollectionRequest;
import org.opennms.integration.api.v1.collectors.ServiceCollectorFactory;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleCollectorFactory
implements ServiceCollectorFactory<SampleCollector> {
    private static final Logger LOG = LoggerFactory.getLogger(SampleCollectorFactory.class);
    private final RuntimeInfo runtimeInfo;

    public SampleCollectorFactory(RuntimeInfo runtimeInfo) {
        this.runtimeInfo = Objects.requireNonNull(runtimeInfo);
    }

    public SampleCollector createCollector() {
        return new SampleCollector(this.runtimeInfo);
    }

    public String getCollectorClassName() {
        return SampleCollector.class.getCanonicalName();
    }

    public Map<String, Object> getRuntimeAttributes(CollectionRequest collectionRequest, Map<String, Object> parameters) {
        return new HashMap<String, Object>();
    }

    public Map<String, String> marshalParameters(Map<String, Object> map) {
        LinkedHashMap<String, String> marshaledMap = new LinkedHashMap<String, String>();
        map.forEach((key, value) -> marshaledMap.put((String)key, value.toString()));
        return marshaledMap;
    }

    public Map<String, Object> unmarshalParameters(Map<String, String> map) {
        LinkedHashMap<String, Object> unmarshaledMap = new LinkedHashMap<String, Object>();
        map.forEach((key, value) -> {
            if ("magicNumber".equals(key)) {
                try {
                    unmarshaledMap.put((String)key, Double.parseDouble(value));
                }
                catch (NumberFormatException ex) {
                    LOG.error("Failed to unmarshal templates from JSON.", (Throwable)ex);
                }
            } else {
                unmarshaledMap.put((String)key, value);
            }
        });
        return unmarshaledMap;
    }
}

