/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.opennms.integration.api.v1.model.Alarm;
import org.opennms.integration.api.v1.model.AlarmFeedback;
import org.opennms.integration.api.v1.model.DatabaseEvent;
import org.opennms.integration.api.v1.model.EventParameter;
import org.opennms.integration.api.v1.model.InMemoryEvent;
import org.opennms.integration.api.v1.model.Severity;
import org.opennms.integration.api.v1.model.immutables.ImmutableAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmTestContextManager {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmTestContextManager.class);
    public static final String TRIGGER_UEI = "uei.opennms.org/oia/sample/trigger";
    public static final String CLEAR_UEI = "uei.opennms.org/oia/sample/clear";
    public static final String SESSION_ID_PARM_NAME = "sessionId";
    private final AtomicLong sessionIdGenerator = new AtomicLong(System.currentTimeMillis());
    private final Random instanceIdGenerator = new Random();
    private final Map<Long, AlarmTestSession> sessionsById = new ConcurrentHashMap<Long, AlarmTestSession>();
    private final List<AlarmFeedback> feedback = new ArrayList<AlarmFeedback>();

    public AlarmTestSession newSession() {
        long sessionId = this.sessionIdGenerator.incrementAndGet();
        AlarmTestSession session = new AlarmTestSession(sessionId, this.instanceIdGenerator.nextLong());
        this.sessionsById.put(sessionId, session);
        return session;
    }

    public Alarm afterAlarmCreated(Alarm alarm, InMemoryEvent event, DatabaseEvent dbEvent) {
        if (!TRIGGER_UEI.equals(event.getUei())) {
            return null;
        }
        AlarmTestSession session = this.getSessionFor(alarm);
        if (session == null) {
            LOG.info("No active session found for alarm: {}", (Object)alarm);
            return null;
        }
        ImmutableAlarm updatedAlarm = ImmutableAlarm.newBuilder().setManagedObjectInstance(session.getInstanceId()).build();
        return updatedAlarm;
    }

    public void handleNewOrUpdatedAlarm(Alarm alarm) {
        if (!TRIGGER_UEI.equals(alarm.getLastEvent().getUei()) && !CLEAR_UEI.equals(alarm.getLastEvent().getUei())) {
            return;
        }
        AlarmTestSession session = this.getSessionFor(alarm);
        if (session == null) {
            LOG.info("No active session found for alarm: {}", (Object)alarm);
        } else {
            session.handleNewOrUpdatedAlarm(alarm);
        }
    }

    public void handleFeedback(AlarmFeedback feedback) {
        LOG.info("Received feedback {}.", (Object)feedback);
        this.feedback.add(feedback);
    }

    private AlarmTestSession getSessionFor(Alarm alarm) {
        Long sessionId;
        DatabaseEvent event = alarm.getLastEvent();
        if (event == null) {
            LOG.warn("No last event found on alarm: {}", (Object)alarm);
            return null;
        }
        String sessionIdAsString = event.getParametersByName(SESSION_ID_PARM_NAME).stream().map(EventParameter::getValue).findFirst().orElse(null);
        if (sessionIdAsString == null) {
            LOG.warn("No session id found on alarm: {}", (Object)alarm);
            return null;
        }
        try {
            sessionId = Long.parseLong(sessionIdAsString);
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Invalid session id '{}' found on alarm: {}", (Object)sessionIdAsString, (Object)alarm);
            return null;
        }
        return this.sessionsById.get(sessionId);
    }

    public class AlarmTestSession
    implements AutoCloseable {
        private final long sessionId;
        private final long instanceId;
        private CountDownLatch triggerLatch = new CountDownLatch(1);
        private CountDownLatch clearLatch = new CountDownLatch(1);

        public AlarmTestSession(long sessionId, long instanceId) {
            this.sessionId = sessionId;
            this.instanceId = instanceId;
        }

        public String getSessionId() {
            return Long.toString(this.sessionId);
        }

        public String getInstanceId() {
            return Long.toString(this.instanceId);
        }

        private void handleNewOrUpdatedAlarm(Alarm alarm) {
            if (!this.getInstanceId().equals(alarm.getManagedObjectInstance())) {
                LOG.warn("Incorrect instance id associated with session - expected: {}, but got: {}", (Object)this.getInstanceId(), (Object)alarm.getManagedObjectInstance());
                return;
            }
            if (alarm.getSeverity() == Severity.WARNING) {
                this.triggerLatch.countDown();
            } else if (alarm.getSeverity() == Severity.CLEARED) {
                this.clearLatch.countDown();
            }
        }

        public void waitForTrigger() throws InterruptedException {
            this.triggerLatch.await();
        }

        public void waitForClear() throws InterruptedException {
            this.clearLatch.await();
        }

        @Override
        public void close() {
            AlarmTestContextManager.this.sessionsById.remove(this.sessionId);
        }
    }
}

