/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db.install;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.config.opennmsDataSources.Param;
import org.postgresql.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDataSource
implements DataSource {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleDataSource.class);
    private String m_driver;
    private String m_url;
    private Properties m_properties = new Properties();
    private Integer m_timeout = null;

    public SimpleDataSource(String driver, String url, String user, String password) throws ClassNotFoundException {
        this.m_driver = driver;
        this.m_url = url;
        this.m_properties.put("user", user);
        this.m_properties.put("password", password);
        Class<?> driverClass = Class.forName(this.m_driver);
        if (Driver.class.getName().equals(this.m_driver)) {
            try {
                boolean isRegistered = (Boolean)driverClass.getMethod("isRegistered", new Class[0]).invoke(null, (Object[])null);
                if (!isRegistered) {
                    LOG.info(Driver.class.getName() + " is not registered, reregistering...");
                    driverClass.getMethod("register", new Class[0]).invoke(null, (Object[])null);
                    LOG.info(Driver.class.getName() + " is registered");
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.warn("Exception while trying to check the registration on the " + Driver.class.getName() + " driver", (Throwable)e);
            }
        }
    }

    public SimpleDataSource(JdbcDataSource ds) throws ClassNotFoundException {
        this(ds.getClassName(), ds.getUrl(), ds.getUserName(), ds.getPassword());
        for (Param param : ds.getParamCollection()) {
            this.m_properties.put(param.getName(), param.getValue());
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.m_timeout == null) {
            return DriverManager.getConnection(this.m_url, this.m_properties);
        }
        int oldTimeout = DriverManager.getLoginTimeout();
        DriverManager.setLoginTimeout(this.m_timeout);
        Connection conn = DriverManager.getConnection(this.m_url, this.m_properties);
        DriverManager.setLoginTimeout(oldTimeout);
        return conn;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("getConnection(String, String) not implemented");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new UnsupportedOperationException("getLogWriter() not implemented");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_timeout == null ? -1 : this.m_timeout;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new UnsupportedOperationException("setLogWriter(PrintWriter) not implemented");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_timeout = seconds;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public String getDriver() {
        return this.m_driver;
    }

    public String getPassword() {
        return this.m_properties.getProperty("password");
    }

    public Integer getTimeout() {
        return this.m_timeout;
    }

    public String getUrl() {
        return this.m_url;
    }

    public String getUser() {
        return this.m_properties.getProperty("user");
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public String toString() {
        StringBuilder props = new StringBuilder();
        if (this.m_properties.isEmpty()) {
            props.append(" none");
        } else {
            boolean first = true;
            for (Map.Entry<Object, Object> entry : this.m_properties.entrySet()) {
                if (!first) {
                    props.append(",");
                }
                props.append(" ");
                props.append(entry.getKey());
                props.append("='");
                props.append(entry.getValue());
                props.append("'");
                first = false;
            }
        }
        return "SimpleDataSource[URL='" + this.getUrl() + "', driver class='" + this.getDriver() + "', properties:" + props + "]";
    }
}

