/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.mate.commands;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.mate.api.ContextKey;
import org.opennms.core.mate.api.EntityScopeProvider;
import org.opennms.core.mate.api.FallbackScope;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsNode;

@Command(scope="opennms", name="metadata-test", description="Test Meta-Data replacement")
@Service
public class MetaCommand
implements Action {
    private static final String MATCHER = "^.*([pP]assword|[sS]ecret).*$";
    @Reference
    private SessionUtils sessionUtils;
    @Reference
    public NodeDao nodeDao;
    @Reference
    public EntityScopeProvider entityScopeProvider;
    @Option(name="-n", aliases={"--node"}, description="Node ID or FS:FID", required=true, multiValued=false)
    private String nodeRef;
    @Option(name="-i", aliases={"--interface-address"}, description="IP Interface Address", required=false, multiValued=false)
    private String interfaceAddress;
    @Option(name="-s", aliases={"--service-name"}, description="Service name", required=false, multiValued=false)
    private String serviceName;
    @Argument(index=0, name="expression", description="Expression to use, e.g. '${context:key|fallback_context:fallback_key|default}'", required=false, multiValued=false)
    private String expression;

    void printScope(Scope scope) {
        Map grouped = scope.keys().stream().collect(Collectors.groupingBy(ContextKey::getContext, TreeMap::new, Collectors.toCollection(TreeSet::new)));
        for (Map.Entry group : grouped.entrySet()) {
            System.out.printf("%s:%n", group.getKey());
            for (ContextKey contextKey : (Set)group.getValue()) {
                boolean omitOutput = "scv".equals(group.getKey()) && "password".equals(contextKey.getKey()) || contextKey.getKey().matches(MATCHER);
                System.out.printf("  %s='%s'%n", contextKey.getKey(), scope.get(contextKey).map(r -> String.format("%s @ %s", omitOutput ? "<output omitted>" : r.value, r.scopeName)).orElse(""));
            }
        }
    }

    public Object execute() throws Exception {
        this.sessionUtils.withReadOnlyTransaction(() -> {
            try {
                OnmsNode onmsNode = this.nodeDao.get(this.nodeRef);
                if (onmsNode == null) {
                    System.out.printf("Cannot find node with ID/FS:FID=%s.%n", this.nodeRef);
                    return null;
                }
                Scope nodeScope = this.entityScopeProvider.getScopeForNode(onmsNode.getId());
                Scope interfaceScope = this.entityScopeProvider.getScopeForInterface(onmsNode.getId(), this.interfaceAddress);
                Scope serviceScope = this.entityScopeProvider.getScopeForService(onmsNode.getId(), InetAddressUtils.getInetAddress((String)this.interfaceAddress), this.serviceName);
                System.out.printf("---%nMeta-Data for node (id=%d)%n", onmsNode.getId());
                this.printScope(nodeScope);
                if (this.interfaceAddress != null) {
                    System.out.printf("---%nMeta-Data for interface (ipAddress=%s):%n", this.interfaceAddress);
                    this.printScope(interfaceScope);
                }
                if (this.serviceName != null) {
                    System.out.printf("---%nMeta-Data for service (name=%s):%n", this.serviceName);
                    this.printScope(serviceScope);
                }
                System.out.printf("---%n", new Object[0]);
                if (!Strings.isNullOrEmpty((String)this.expression)) {
                    Interpolator.Result result = Interpolator.interpolate((String)this.expression, (Scope)new FallbackScope(new Scope[]{nodeScope, interfaceScope, serviceScope}));
                    System.out.printf("Input: '%s'%nOutput: '%s'%n", this.expression, result.output);
                    System.out.printf("Details:%n", new Object[0]);
                    for (Interpolator.ResultPart resultPart : result.parts) {
                        System.out.printf("  Part: '%s' => match='%s', value='%s', scope='%s'%n", resultPart.input, resultPart.match, resultPart.value.value, resultPart.value.scopeName);
                    }
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        return null;
    }
}

