/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.opennms.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.opennms.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.opennms.shaded.org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.opennms.shaded.org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import org.opennms.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.opennms.shaded.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.DHParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.tls.Certificate;
import org.opennms.shaded.org.bouncycastle.crypto.tls.CertificateRequest;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsAgreementCredentials;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsClientContext;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsCredentials;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsDSSSigner;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsKeyExchange;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsRSASigner;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsSigner;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsUtils;
import org.opennms.shaded.org.bouncycastle.crypto.util.PublicKeyFactory;
import org.opennms.shaded.org.bouncycastle.util.BigIntegers;

class TlsDHKeyExchange
implements TlsKeyExchange {
    protected static final BigInteger ONE = BigInteger.valueOf(1L);
    protected static final BigInteger TWO = BigInteger.valueOf(2L);
    protected TlsClientContext context;
    protected int keyExchange;
    protected TlsSigner tlsSigner;
    protected AsymmetricKeyParameter serverPublicKey = null;
    protected DHPublicKeyParameters dhAgreeServerPublicKey = null;
    protected TlsAgreementCredentials agreementCredentials;
    protected DHPrivateKeyParameters dhAgreeClientPrivateKey = null;

    TlsDHKeyExchange(TlsClientContext tlsClientContext, int n) {
        switch (n) {
            case 7: 
            case 9: {
                this.tlsSigner = null;
                break;
            }
            case 5: {
                this.tlsSigner = new TlsRSASigner();
                break;
            }
            case 3: {
                this.tlsSigner = new TlsDSSSigner();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.context = tlsClientContext;
        this.keyExchange = n;
    }

    public void skipServerCertificate() throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processServerCertificate(Certificate certificate) throws IOException {
        X509CertificateStructure x509CertificateStructure = certificate.certs[0];
        SubjectPublicKeyInfo subjectPublicKeyInfo = x509CertificateStructure.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(subjectPublicKeyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43);
        }
        if (this.tlsSigner == null) {
            try {
                this.dhAgreeServerPublicKey = this.validateDHPublicKey((DHPublicKeyParameters)this.serverPublicKey);
            }
            catch (ClassCastException classCastException) {
                throw new TlsFatalAlert(46);
            }
            TlsUtils.validateKeyUsage(x509CertificateStructure, 8);
        } else {
            if (!this.tlsSigner.isValidPublicKey(this.serverPublicKey)) {
                throw new TlsFatalAlert(46);
            }
            TlsUtils.validateKeyUsage(x509CertificateStructure, 128);
        }
    }

    public void skipServerKeyExchange() throws IOException {
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] sArray = certificateRequest.getCertificateTypes();
        block3: for (int i = 0; i < sArray.length; ++i) {
            switch (sArray[i]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 64: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    public void skipClientCredentials() throws IOException {
        this.agreementCredentials = null;
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (tlsCredentials instanceof TlsAgreementCredentials) {
            this.agreementCredentials = (TlsAgreementCredentials)tlsCredentials;
        } else if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        if (this.agreementCredentials != null) {
            TlsUtils.writeUint24(0, outputStream);
        } else {
            this.generateEphemeralClientKeyExchange(this.dhAgreeServerPublicKey.getParameters(), outputStream);
        }
    }

    public byte[] generatePremasterSecret() throws IOException {
        if (this.agreementCredentials != null) {
            return this.agreementCredentials.generateAgreement(this.dhAgreeServerPublicKey);
        }
        return this.calculateDHBasicAgreement(this.dhAgreeServerPublicKey, this.dhAgreeClientPrivateKey);
    }

    protected boolean areCompatibleParameters(DHParameters dHParameters, DHParameters dHParameters2) {
        return dHParameters.getP().equals(dHParameters2.getP()) && dHParameters.getG().equals(dHParameters2.getG());
    }

    protected byte[] calculateDHBasicAgreement(DHPublicKeyParameters dHPublicKeyParameters, DHPrivateKeyParameters dHPrivateKeyParameters) {
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        dHBasicAgreement.init(this.dhAgreeClientPrivateKey);
        BigInteger bigInteger = dHBasicAgreement.calculateAgreement(this.dhAgreeServerPublicKey);
        return BigIntegers.asUnsignedByteArray(bigInteger);
    }

    protected AsymmetricCipherKeyPair generateDHKeyPair(DHParameters dHParameters) {
        DHBasicKeyPairGenerator dHBasicKeyPairGenerator = new DHBasicKeyPairGenerator();
        dHBasicKeyPairGenerator.init(new DHKeyGenerationParameters(this.context.getSecureRandom(), dHParameters));
        return dHBasicKeyPairGenerator.generateKeyPair();
    }

    protected void generateEphemeralClientKeyExchange(DHParameters dHParameters, OutputStream outputStream) throws IOException {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.generateDHKeyPair(dHParameters);
        this.dhAgreeClientPrivateKey = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        BigInteger bigInteger = ((DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getY();
        byte[] byArray = BigIntegers.asUnsignedByteArray(bigInteger);
        TlsUtils.writeUint24(byArray.length + 2, outputStream);
        TlsUtils.writeOpaque16(byArray, outputStream);
    }

    protected DHPublicKeyParameters validateDHPublicKey(DHPublicKeyParameters dHPublicKeyParameters) throws IOException {
        BigInteger bigInteger = dHPublicKeyParameters.getY();
        DHParameters dHParameters = dHPublicKeyParameters.getParameters();
        BigInteger bigInteger2 = dHParameters.getP();
        BigInteger bigInteger3 = dHParameters.getG();
        if (!bigInteger2.isProbablePrime(2)) {
            throw new TlsFatalAlert(47);
        }
        if (bigInteger3.compareTo(TWO) < 0 || bigInteger3.compareTo(bigInteger2.subtract(TWO)) > 0) {
            throw new TlsFatalAlert(47);
        }
        if (bigInteger.compareTo(TWO) < 0 || bigInteger.compareTo(bigInteger2.subtract(ONE)) > 0) {
            throw new TlsFatalAlert(47);
        }
        return dHPublicKeyParameters;
    }
}

