/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.asn1.crmf;

import org.opennms.shaded.org.bouncycastle.asn1.ASN1Choice;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERBitString;
import org.opennms.shaded.org.bouncycastle.asn1.DERInteger;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.cms.EnvelopedData;
import org.opennms.shaded.org.bouncycastle.asn1.crmf.PKMACValue;
import org.opennms.shaded.org.bouncycastle.asn1.crmf.SubsequentMessage;

public class POPOPrivKey
extends ASN1Encodable
implements ASN1Choice {
    public static final int thisMessage = 0;
    public static final int subsequentMessage = 1;
    public static final int dhMAC = 2;
    public static final int agreeMAC = 3;
    public static final int encryptedKey = 4;
    private int tagNo;
    private ASN1Encodable obj;

    private POPOPrivKey(ASN1TaggedObject aSN1TaggedObject) {
        this.tagNo = aSN1TaggedObject.getTagNo();
        switch (this.tagNo) {
            case 0: {
                this.obj = DERBitString.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 1: {
                this.obj = SubsequentMessage.valueOf(DERInteger.getInstance(aSN1TaggedObject, false).getValue().intValue());
                break;
            }
            case 2: {
                this.obj = DERBitString.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 3: {
                this.obj = PKMACValue.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 4: {
                this.obj = EnvelopedData.getInstance(aSN1TaggedObject, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag in POPOPrivKey");
            }
        }
    }

    public static POPOPrivKey getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return new POPOPrivKey(ASN1TaggedObject.getInstance(aSN1TaggedObject.getObject()));
    }

    public POPOPrivKey(SubsequentMessage subsequentMessage) {
        this.tagNo = 1;
        this.obj = subsequentMessage;
    }

    public int getType() {
        return this.tagNo;
    }

    public ASN1Encodable getValue() {
        return this.obj;
    }

    public DERObject toASN1Object() {
        return new DERTaggedObject(false, this.tagNo, this.obj);
    }
}

