/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.handler.event;

import net.jradius.handler.EventHandlerBase;
import net.jradius.log.JRadiusLogEntry;
import net.jradius.log.RadiusLog;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.event.SessionExpiredEvent;
import net.jradius.session.JRadiusSession;

public class SessionExpiredHandler
extends EventHandlerBase {
    public boolean handle(JRadiusEvent evt) throws Exception {
        if (evt instanceof SessionExpiredEvent) {
            SessionExpiredEvent event = (SessionExpiredEvent)evt;
            JRadiusSession session = event.getSession();
            if (session == null) {
                return true;
            }
            RadiusLog.debug((String)("Processing Session Expired Event for Session: " + session.getSessionKey()));
            if (session.getSessionState() == -1) {
                this.onRadiusError(event);
            } else if ((session.getSessionState() & 0x10) != 0) {
                this.onAcctStopped(event);
            } else if ((session.getSessionState() & 8) != 0) {
                this.onAcctStarted(event);
            } else if ((session.getSessionState() & 4) != 0) {
                this.onAuthRejected(event);
            } else if ((session.getSessionState() & 2) != 0) {
                int iServiceType;
                Long serviceType = session.getServiceType();
                if (serviceType != null && (iServiceType = serviceType.intValue()) != 6 && iServiceType != 8) {
                    this.onAuthAccepted(event);
                }
            } else if ((session.getSessionState() & 4) != 0) {
                this.onAuthPending(event);
            }
            return true;
        }
        return false;
    }

    public void onRadiusError(SessionExpiredEvent event) {
        JRadiusSession session = event.getSession();
        String error = "Session Expired in Error State";
        RadiusLog.error((String)(session.getSessionKey() + ": " + error));
        JRadiusLogEntry logEntry = session.getLogEntry((JRadiusEvent)event, "0");
        logEntry.setType("error");
        logEntry.addMessage(error);
        session.commitLogEntries(1);
    }

    public void onAuthPending(SessionExpiredEvent event) {
        RadiusLog.problem(null, (JRadiusSession)event.getSession(), null, (String)"Expired in Auth-Pending state (no response from service provider)");
    }

    public void onAuthAccepted(SessionExpiredEvent event) {
        JRadiusSession session = event.getSession();
        String error = "Session Expired in Auth-Accepted state, Accounting never started";
        RadiusLog.warn((String)(session.getSessionKey() + ": " + error));
        JRadiusLogEntry logEntry = session.getLogEntry((JRadiusEvent)event, "0");
        logEntry.setType("error");
        logEntry.addMessage(error);
        session.commitLogEntries(1);
    }

    public void onAuthRejected(SessionExpiredEvent event) {
        RadiusLog.debug((String)("Rejected Session Expired: " + event));
    }

    public void onAcctStarted(SessionExpiredEvent event) {
        JRadiusSession session = event.getSession();
        String error = "Session Expired in Accounting-Started state, Accounting never stopped";
        RadiusLog.warn((String)(session.getSessionKey() + ": " + error));
        JRadiusLogEntry logEntry = session.getLogEntry((JRadiusEvent)event, "0");
        logEntry.setType("error");
        logEntry.addMessage(error);
    }

    public void onAcctStopped(SessionExpiredEvent event) {
        RadiusLog.debug((String)("Completed Session Expired: " + event));
    }
}

