/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.handler.accounting;

import net.jradius.exception.RadiusException;
import net.jradius.handler.RadiusSessionHandler;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.server.JRadiusRequest;
import net.jradius.session.JRadiusSession;

public class AccountingClassHandler
extends RadiusSessionHandler {
    public boolean handle(JRadiusRequest request) throws RadiusException {
        String sClass;
        JRadiusSession session = request.getSession();
        if (session == null) {
            return this.noSessionFound(request);
        }
        RadiusPacket req = request.getRequestPacket();
        byte[] bClass = (byte[])req.getAttributeValue(25L);
        if (bClass != null && (sClass = new String(bClass)).startsWith("JRADIUS-CLASS:")) {
            req.removeAttribute(25L);
            byte[][] classes = session.getRadiusClass();
            if (classes != null) {
                for (byte[] c : classes) {
                    RadiusAttribute cattr = AttributeFactory.newAttribute((long)25L, (byte[])c, (boolean)req.isRecyclable());
                    req.addAttribute(cattr);
                }
            }
            return false;
        }
        session.addLogMessage(request, "Accounting without Class Attribute");
        return false;
    }
}

