/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.AfterTransactionCompletionProcess;
import org.hibernate.action.BeforeTransactionCompletionProcess;
import org.hibernate.action.BulkOperationCleanupAction;
import org.hibernate.action.CollectionRecreateAction;
import org.hibernate.action.CollectionRemoveAction;
import org.hibernate.action.CollectionUpdateAction;
import org.hibernate.action.EntityDeleteAction;
import org.hibernate.action.EntityIdentityInsertAction;
import org.hibernate.action.EntityInsertAction;
import org.hibernate.action.EntityUpdateAction;
import org.hibernate.action.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionQueue {
    private static final Logger log = LoggerFactory.getLogger(ActionQueue.class);
    private static final int INIT_QUEUE_LIST_SIZE = 5;
    private SessionImplementor session;
    private ArrayList insertions;
    private ArrayList deletions;
    private ArrayList updates;
    private ArrayList collectionCreations;
    private ArrayList collectionUpdates;
    private ArrayList collectionRemovals;
    private AfterTransactionCompletionProcessQueue afterTransactionProcesses;
    private BeforeTransactionCompletionProcessQueue beforeTransactionProcesses;

    public ActionQueue(SessionImplementor session) {
        this.session = session;
        this.init();
    }

    private void init() {
        this.insertions = new ArrayList(5);
        this.deletions = new ArrayList(5);
        this.updates = new ArrayList(5);
        this.collectionCreations = new ArrayList(5);
        this.collectionRemovals = new ArrayList(5);
        this.collectionUpdates = new ArrayList(5);
        this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
        this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
    }

    public void clear() {
        this.updates.clear();
        this.insertions.clear();
        this.deletions.clear();
        this.collectionCreations.clear();
        this.collectionRemovals.clear();
        this.collectionUpdates.clear();
    }

    public void addAction(EntityInsertAction action) {
        this.insertions.add(action);
    }

    public void addAction(EntityDeleteAction action) {
        this.deletions.add(action);
    }

    public void addAction(EntityUpdateAction action) {
        this.updates.add(action);
    }

    public void addAction(CollectionRecreateAction action) {
        this.collectionCreations.add(action);
    }

    public void addAction(CollectionRemoveAction action) {
        this.collectionRemovals.add(action);
    }

    public void addAction(CollectionUpdateAction action) {
        this.collectionUpdates.add(action);
    }

    public void addAction(EntityIdentityInsertAction insert) {
        this.insertions.add(insert);
    }

    public void addAction(BulkOperationCleanupAction cleanupAction) {
        this.registerCleanupActions(cleanupAction);
    }

    public void registerProcess(AfterTransactionCompletionProcess process) {
        this.afterTransactionProcesses.register(process);
    }

    public void registerProcess(BeforeTransactionCompletionProcess process) {
        this.beforeTransactionProcesses.register(process);
    }

    public void executeInserts() throws HibernateException {
        this.executeActions(this.insertions);
    }

    public void executeActions() throws HibernateException {
        this.executeActions(this.insertions);
        this.executeActions(this.updates);
        this.executeActions(this.collectionRemovals);
        this.executeActions(this.collectionUpdates);
        this.executeActions(this.collectionCreations);
        this.executeActions(this.deletions);
    }

    public void prepareActions() throws HibernateException {
        this.prepareActions(this.collectionRemovals);
        this.prepareActions(this.collectionUpdates);
        this.prepareActions(this.collectionCreations);
    }

    public void afterTransactionCompletion(boolean success) {
        this.afterTransactionProcesses.afterTransactionCompletion(success);
    }

    public void beforeTransactionCompletion() {
        this.beforeTransactionProcesses.beforeTransactionCompletion();
    }

    public boolean areTablesToBeUpdated(Set tables) {
        return ActionQueue.areTablesToUpdated(this.updates, tables) || ActionQueue.areTablesToUpdated(this.insertions, tables) || ActionQueue.areTablesToUpdated(this.deletions, tables) || ActionQueue.areTablesToUpdated(this.collectionUpdates, tables) || ActionQueue.areTablesToUpdated(this.collectionCreations, tables) || ActionQueue.areTablesToUpdated(this.collectionRemovals, tables);
    }

    public boolean areInsertionsOrDeletionsQueued() {
        return this.insertions.size() > 0 || this.deletions.size() > 0;
    }

    private static boolean areTablesToUpdated(List actions, Set tableSpaces) {
        for (Executable action : actions) {
            Serializable[] spaces;
            for (Serializable space : spaces = action.getPropertySpaces()) {
                if (!tableSpaces.contains(space)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("changes must be flushed to space: " + space);
                }
                return true;
            }
        }
        return false;
    }

    private void executeActions(List list) throws HibernateException {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            this.execute((Executable)list.get(i));
        }
        list.clear();
        this.session.getBatcher().executeBatch();
    }

    public void execute(Executable executable) {
        try {
            executable.execute();
        }
        finally {
            this.registerCleanupActions(executable);
        }
    }

    private void registerCleanupActions(Executable executable) {
        this.beforeTransactionProcesses.register(executable.getBeforeTransactionCompletionProcess());
        if (this.session.getFactory().getSettings().isQueryCacheEnabled()) {
            String[] spaces = (String[])executable.getPropertySpaces();
            this.afterTransactionProcesses.addSpacesToInvalidate(spaces);
            this.session.getFactory().getUpdateTimestampsCache().preinvalidate((Serializable[])spaces);
        }
        this.afterTransactionProcesses.register(executable.getAfterTransactionCompletionProcess());
    }

    private void prepareActions(List queue) throws HibernateException {
        for (Executable executable : queue) {
            executable.beforeExecutions();
        }
    }

    public String toString() {
        return new StringBuffer().append("ActionQueue[insertions=").append(this.insertions).append(" updates=").append(this.updates).append(" deletions=").append(this.deletions).append(" collectionCreations=").append(this.collectionCreations).append(" collectionRemovals=").append(this.collectionRemovals).append(" collectionUpdates=").append(this.collectionUpdates).append("]").toString();
    }

    public int numberOfCollectionRemovals() {
        return this.collectionRemovals.size();
    }

    public int numberOfCollectionUpdates() {
        return this.collectionUpdates.size();
    }

    public int numberOfCollectionCreations() {
        return this.collectionCreations.size();
    }

    public int numberOfDeletions() {
        return this.deletions.size();
    }

    public int numberOfUpdates() {
        return this.updates.size();
    }

    public int numberOfInsertions() {
        return this.insertions.size();
    }

    public void sortCollectionActions() {
        if (this.session.getFactory().getSettings().isOrderUpdatesEnabled()) {
            Collections.sort(this.collectionCreations);
            Collections.sort(this.collectionUpdates);
            Collections.sort(this.collectionRemovals);
        }
    }

    public void sortActions() {
        if (this.session.getFactory().getSettings().isOrderUpdatesEnabled()) {
            Collections.sort(this.updates);
        }
        if (this.session.getFactory().getSettings().isOrderInsertsEnabled()) {
            this.sortInsertActions();
        }
    }

    private void sortInsertActions() {
        new InsertActionSorter().sort();
    }

    public ArrayList cloneDeletions() {
        return (ArrayList)this.deletions.clone();
    }

    public void clearFromFlushNeededCheck(int previousCollectionRemovalSize) {
        this.collectionCreations.clear();
        this.collectionUpdates.clear();
        this.updates.clear();
        for (int i = this.collectionRemovals.size() - 1; i >= previousCollectionRemovalSize; --i) {
            this.collectionRemovals.remove(i);
        }
    }

    public boolean hasAfterTransactionActions() {
        return this.afterTransactionProcesses.processes.size() > 0;
    }

    public boolean hasBeforeTransactionActions() {
        return this.beforeTransactionProcesses.processes.size() > 0;
    }

    public boolean hasAnyQueuedActions() {
        return this.updates.size() > 0 || this.insertions.size() > 0 || this.deletions.size() > 0 || this.collectionUpdates.size() > 0 || this.collectionRemovals.size() > 0 || this.collectionCreations.size() > 0;
    }

    public void unScheduleDeletion(EntityEntry entry, Object rescuedEntity) {
        for (int i = 0; i < this.deletions.size(); ++i) {
            EntityDeleteAction action = (EntityDeleteAction)this.deletions.get(i);
            if (action.getInstance() != rescuedEntity) continue;
            this.deletions.remove(i);
            return;
        }
        throw new AssertionFailure("Unable to perform un-delete for instance " + entry.getEntityName());
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        int i;
        log.trace("serializing action-queue");
        int queueSize = this.insertions.size();
        log.trace("starting serialization of [" + queueSize + "] insertions entries");
        oos.writeInt(queueSize);
        for (i = 0; i < queueSize; ++i) {
            oos.writeObject(this.insertions.get(i));
        }
        queueSize = this.deletions.size();
        log.trace("starting serialization of [" + queueSize + "] deletions entries");
        oos.writeInt(queueSize);
        for (i = 0; i < queueSize; ++i) {
            oos.writeObject(this.deletions.get(i));
        }
        queueSize = this.updates.size();
        log.trace("starting serialization of [" + queueSize + "] updates entries");
        oos.writeInt(queueSize);
        for (i = 0; i < queueSize; ++i) {
            oos.writeObject(this.updates.get(i));
        }
        queueSize = this.collectionUpdates.size();
        log.trace("starting serialization of [" + queueSize + "] collectionUpdates entries");
        oos.writeInt(queueSize);
        for (i = 0; i < queueSize; ++i) {
            oos.writeObject(this.collectionUpdates.get(i));
        }
        queueSize = this.collectionRemovals.size();
        log.trace("starting serialization of [" + queueSize + "] collectionRemovals entries");
        oos.writeInt(queueSize);
        for (i = 0; i < queueSize; ++i) {
            oos.writeObject(this.collectionRemovals.get(i));
        }
        queueSize = this.collectionCreations.size();
        log.trace("starting serialization of [" + queueSize + "] collectionCreations entries");
        oos.writeInt(queueSize);
        for (i = 0; i < queueSize; ++i) {
            oos.writeObject(this.collectionCreations.get(i));
        }
    }

    public static ActionQueue deserialize(ObjectInputStream ois, SessionImplementor session) throws IOException, ClassNotFoundException {
        int i;
        log.trace("deserializing action-queue");
        ActionQueue rtn = new ActionQueue(session);
        int queueSize = ois.readInt();
        log.trace("starting deserialization of [" + queueSize + "] insertions entries");
        rtn.insertions = new ArrayList(queueSize);
        for (i = 0; i < queueSize; ++i) {
            rtn.insertions.add(ois.readObject());
        }
        queueSize = ois.readInt();
        log.trace("starting deserialization of [" + queueSize + "] deletions entries");
        rtn.deletions = new ArrayList(queueSize);
        for (i = 0; i < queueSize; ++i) {
            rtn.deletions.add(ois.readObject());
        }
        queueSize = ois.readInt();
        log.trace("starting deserialization of [" + queueSize + "] updates entries");
        rtn.updates = new ArrayList(queueSize);
        for (i = 0; i < queueSize; ++i) {
            rtn.updates.add(ois.readObject());
        }
        queueSize = ois.readInt();
        log.trace("starting deserialization of [" + queueSize + "] collectionUpdates entries");
        rtn.collectionUpdates = new ArrayList(queueSize);
        for (i = 0; i < queueSize; ++i) {
            rtn.collectionUpdates.add(ois.readObject());
        }
        queueSize = ois.readInt();
        log.trace("starting deserialization of [" + queueSize + "] collectionRemovals entries");
        rtn.collectionRemovals = new ArrayList(queueSize);
        for (i = 0; i < queueSize; ++i) {
            rtn.collectionRemovals.add(ois.readObject());
        }
        queueSize = ois.readInt();
        log.trace("starting deserialization of [" + queueSize + "] collectionCreations entries");
        rtn.collectionCreations = new ArrayList(queueSize);
        for (i = 0; i < queueSize; ++i) {
            rtn.collectionCreations.add(ois.readObject());
        }
        return rtn;
    }

    private class InsertActionSorter {
        private HashMap latestBatches = new HashMap();
        private HashMap entityBatchNumber;
        private HashMap actionBatches = new HashMap();

        public InsertActionSorter() {
            this.entityBatchNumber = new HashMap(ActionQueue.this.insertions.size() + 1, 1.0f);
        }

        public void sort() {
            for (EntityInsertAction action : ActionQueue.this.insertions) {
                Integer batchNumber;
                String entityName = action.getEntityName();
                Object currentEntity = action.getInstance();
                if (this.latestBatches.containsKey(entityName)) {
                    batchNumber = this.findBatchNumber(action, entityName);
                } else {
                    batchNumber = this.actionBatches.size();
                    this.latestBatches.put(entityName, batchNumber);
                }
                this.entityBatchNumber.put(currentEntity, batchNumber);
                this.addToBatch(batchNumber, action);
            }
            ActionQueue.this.insertions.clear();
            for (int i = 0; i < this.actionBatches.size(); ++i) {
                List batch = (List)this.actionBatches.get(new Integer(i));
                for (Object aBatch : batch) {
                    EntityInsertAction action = (EntityInsertAction)aBatch;
                    ActionQueue.this.insertions.add(action);
                }
            }
        }

        private Integer findBatchNumber(EntityInsertAction action, String entityName) {
            Integer latestBatchNumberForType = (Integer)this.latestBatches.get(entityName);
            Object[] propertyValues = action.getState();
            Type[] propertyTypes = action.getPersister().getClassMetadata().getPropertyTypes();
            for (int i = 0; i < propertyValues.length; ++i) {
                Integer associationBatchNumber;
                Object value = propertyValues[i];
                Type type = propertyTypes[i];
                if (!type.isEntityType() || value == null || (associationBatchNumber = (Integer)this.entityBatchNumber.get(value)) == null || associationBatchNumber.compareTo(latestBatchNumberForType) <= 0) continue;
                latestBatchNumberForType = this.actionBatches.size();
                this.latestBatches.put(entityName, latestBatchNumberForType);
                break;
            }
            return latestBatchNumberForType;
        }

        private void addToBatch(Integer batchNumber, EntityInsertAction action) {
            LinkedList<EntityInsertAction> actions = (LinkedList<EntityInsertAction>)this.actionBatches.get(batchNumber);
            if (actions == null) {
                actions = new LinkedList<EntityInsertAction>();
                this.actionBatches.put(batchNumber, actions);
            }
            actions.add(action);
        }
    }

    private static class AfterTransactionCompletionProcessQueue {
        private SessionImplementor session;
        private Set<String> querySpacesToInvalidate = new HashSet<String>();
        private List<AfterTransactionCompletionProcess> processes = new ArrayList<AfterTransactionCompletionProcess>(15);

        private AfterTransactionCompletionProcessQueue(SessionImplementor session) {
            this.session = session;
        }

        public void addSpacesToInvalidate(String[] spaces) {
            if (spaces == null) {
                return;
            }
            int max = spaces.length;
            for (int i = 0; i < max; ++i) {
                this.addSpaceToInvalidate(spaces[i]);
            }
        }

        public void addSpaceToInvalidate(String space) {
            this.querySpacesToInvalidate.add(space);
        }

        public void register(AfterTransactionCompletionProcess process) {
            if (process == null) {
                return;
            }
            this.processes.add(process);
        }

        public void afterTransactionCompletion(boolean success) {
            int size = this.processes.size();
            for (int i = 0; i < size; ++i) {
                try {
                    AfterTransactionCompletionProcess process = this.processes.get(i);
                    process.doAfterTransactionCompletion(success, this.session);
                    continue;
                }
                catch (CacheException ce) {
                    log.error("could not release a cache lock", (Throwable)ce);
                    continue;
                }
                catch (Exception e) {
                    throw new AssertionFailure("Exception releasing cache locks", e);
                }
            }
            this.processes.clear();
            if (this.session.getFactory().getSettings().isQueryCacheEnabled()) {
                this.session.getFactory().getUpdateTimestampsCache().invalidate((Serializable[])this.querySpacesToInvalidate.toArray(new String[this.querySpacesToInvalidate.size()]));
            }
            this.querySpacesToInvalidate.clear();
        }
    }

    private static class BeforeTransactionCompletionProcessQueue {
        private SessionImplementor session;
        private List<BeforeTransactionCompletionProcess> processes = new ArrayList<BeforeTransactionCompletionProcess>();

        private BeforeTransactionCompletionProcessQueue(SessionImplementor session) {
            this.session = session;
        }

        public void register(BeforeTransactionCompletionProcess process) {
            if (process == null) {
                return;
            }
            this.processes.add(process);
        }

        public void beforeTransactionCompletion() {
            int size = this.processes.size();
            for (int i = 0; i < size; ++i) {
                try {
                    BeforeTransactionCompletionProcess process = this.processes.get(i);
                    process.doBeforeTransactionCompletion(this.session);
                    continue;
                }
                catch (HibernateException he) {
                    throw he;
                }
                catch (Exception e) {
                    throw new AssertionFailure("Unable to perform beforeTransactionCompletion callback", e);
                }
            }
            this.processes.clear();
        }
    }
}

