/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.model.functions.reduce;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.functions.reduce.Threshold;
import org.opennms.netmgt.bsm.service.model.graph.GraphEdge;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;

public class ThresholdResultExplanation {
    private Threshold function;
    private List<Status> weightStatuses;
    private Status result;
    private Map<Status, Integer> hitsByStatus;
    private Collection<GraphEdge> edges;
    private Map<GraphEdge, GraphVertex> graphEdgeToGraphVertexMapping;

    public void setFunction(Threshold function) {
        this.function = function;
    }

    public Threshold getFunction() {
        return this.function;
    }

    public void setWeightStatuses(List<Status> weightStatuses) {
        this.weightStatuses = weightStatuses;
    }

    public List<Status> getWeightStatuses() {
        return this.weightStatuses;
    }

    public void setStatus(Status result) {
        this.result = result;
    }

    public void setHitsByStatus(Map<Status, Integer> hitsByStatus) {
        this.hitsByStatus = hitsByStatus;
    }

    public Map<Status, Integer> getHitsByStatus() {
        return this.hitsByStatus;
    }

    public Status getStatus() {
        return this.result;
    }

    public void setGraphEdges(Collection<GraphEdge> edges) {
        this.edges = edges;
    }

    public Collection<GraphEdge> getGraphEdges() {
        return this.edges;
    }

    public double getWeightFactor(GraphEdge eachEdge) {
        int weightSum = this.getWeightSum();
        return (double)eachEdge.getWeight() / (double)weightSum;
    }

    public double getStatusFactor(GraphEdge eachEdge, Status status) {
        if (eachEdge.getStatus().isGreaterThanOrEqual(status)) {
            return this.getWeightFactor(eachEdge);
        }
        return 0.0;
    }

    public double getStatusResult(Status status) {
        if (this.getHitsByStatus().get(status) != null) {
            return (double)this.getHitsByStatus().get(status).intValue() / (double)this.getWeightStatuses().size();
        }
        return 0.0;
    }

    public void setGraphEdgeToGraphVertexMapping(Map<GraphEdge, GraphVertex> graphEdgeToGraphVertexMapping) {
        this.graphEdgeToGraphVertexMapping = graphEdgeToGraphVertexMapping;
    }

    public Map<GraphEdge, GraphVertex> getGraphEdgeToGraphVertexMapping() {
        return this.graphEdgeToGraphVertexMapping;
    }

    public GraphVertex getGraphVertex(GraphEdge graphEdge) {
        return this.graphEdgeToGraphVertexMapping.get(graphEdge);
    }

    public int getWeightSum() {
        return this.getGraphEdges().stream().mapToInt(GraphEdge::getWeight).sum();
    }

    public double getWeightSumFactor() {
        return this.getGraphEdges().stream().mapToDouble(this::getWeightFactor).sum();
    }
}

