/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.websso;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnContextDeclRef;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Condition;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.EncryptedAssertion;
import org.opensaml.saml2.core.EncryptedAttribute;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.OneTimeUse;
import org.opensaml.saml2.core.ProxyRestriction;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.validation.ValidationException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.SAMLStatusException;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.storage.SAMLMessageStorage;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.security.saml.websso.AbstractProfileBase;
import org.springframework.security.saml.websso.WebSSOProfileConsumer;
import org.springframework.util.Assert;

public class WebSSOProfileConsumerImpl
extends AbstractProfileBase
implements WebSSOProfileConsumer {
    private long maxAuthenticationAge = 7200L;
    private boolean includeAllAttributes = false;
    private boolean releaseDOM = true;

    public WebSSOProfileConsumerImpl() {
    }

    public WebSSOProfileConsumerImpl(SAMLProcessor processor, MetadataManager manager) {
        super(processor, manager);
    }

    @Override
    public String getProfileIdentifier() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser";
    }

    @Override
    public SAMLCredential processAuthenticationResponse(SAMLMessageContext context) throws SAMLException, SecurityException, ValidationException, DecryptionException {
        AuthnRequest request = null;
        SAMLObject message = context.getInboundSAMLMessage();
        if (!(message instanceof Response)) {
            throw new SAMLException("Message is not of a Response object type");
        }
        Response response = (Response)message;
        StatusCode statusCode = response.getStatus().getStatusCode();
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode.getValue())) {
            StatusMessage statusMessage = response.getStatus().getStatusMessage();
            String statusMessageText = null;
            if (statusMessage != null) {
                statusMessageText = statusMessage.getMessage();
            }
            String finalStatusCode = statusCode.getValue();
            while (statusCode.getStatusCode() != null) {
                finalStatusCode = statusCode.getStatusCode().getValue();
                statusCode = statusCode.getStatusCode();
            }
            throw new SAMLStatusException(finalStatusCode, "Response has invalid status code " + finalStatusCode + ", status message is " + statusMessageText);
        }
        if (response.getSignature() != null && !context.isInboundSAMLMessageAuthenticated()) {
            this.log.debug("Verifying Response signature");
            this.verifySignature(response.getSignature(), context.getPeerEntityId(), context.getLocalTrustEngine());
            context.setInboundSAMLMessageAuthenticated(true);
        }
        DateTime time = response.getIssueInstant();
        if (!SAMLUtil.isDateTimeSkewValid(this.getResponseSkew(), time)) {
            throw new SAMLException("Response issue time is either too old or with date in the future, skew " + this.getResponseSkew() + ", time " + time);
        }
        if (!context.getPeerExtendedMetadata().isSupportUnsolicitedResponse() && response.getInResponseTo() == null) {
            throw new SAMLException("Reception of Unsolicited Response messages (without InResponseToField) is disabled");
        }
        SAMLMessageStorage messageStorage = context.getMessageStorage();
        if (messageStorage != null && response.getInResponseTo() != null) {
            XMLObject xmlObject = messageStorage.retrieveMessage(response.getInResponseTo());
            if (xmlObject == null) {
                throw new SAMLException("InResponseToField of the Response doesn't correspond to sent message " + response.getInResponseTo());
            }
            if (xmlObject instanceof AuthnRequest) {
                request = (AuthnRequest)xmlObject;
            } else {
                throw new SAMLException("Sent request was of different type than the expected AuthnRequest " + response.getInResponseTo());
            }
        }
        this.verifyEndpoint(context.getLocalEntityEndpoint(), response.getDestination());
        if (request != null) {
            AssertionConsumerService assertionConsumerService = (AssertionConsumerService)context.getLocalEntityEndpoint();
            if (request.getAssertionConsumerServiceIndex() != null) {
                if (!request.getAssertionConsumerServiceIndex().equals(assertionConsumerService.getIndex())) {
                    this.log.info("Response was received at a different endpoint index than was requested");
                }
            } else {
                String responseLocation;
                String requestedResponseURL = request.getAssertionConsumerServiceURL();
                String requestedBinding = request.getProtocolBinding();
                if (requestedResponseURL != null && !requestedResponseURL.equals(responseLocation = assertionConsumerService.getResponseLocation() != null ? assertionConsumerService.getResponseLocation() : assertionConsumerService.getLocation())) {
                    this.log.info("Response was received at a different endpoint URL {} than was requested {}", (Object)responseLocation, (Object)requestedResponseURL);
                }
                if (requestedBinding != null && !requestedBinding.equals(context.getInboundSAMLBinding())) {
                    this.log.info("Response was received using a different binding {} than was requested {}", (Object)context.getInboundSAMLBinding(), (Object)requestedBinding);
                }
            }
        }
        if (response.getIssuer() != null) {
            this.log.debug("Verifying issuer of the Response");
            Issuer issuer = response.getIssuer();
            this.verifyIssuer(issuer, context);
        }
        Assertion subjectAssertion = null;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        ArrayList<Assertion> assertionList = response.getAssertions();
        if (response.getEncryptedAssertions().size() > 0) {
            assertionList = new ArrayList<Assertion>(response.getAssertions().size() + response.getEncryptedAssertions().size());
            assertionList.addAll(response.getAssertions());
            List encryptedAssertionList = response.getEncryptedAssertions();
            for (EncryptedAssertion ea : encryptedAssertionList) {
                try {
                    Assert.notNull((Object)context.getLocalDecrypter(), (String)"Can't decrypt Assertion, no decrypter is set in the context");
                    this.log.debug("Decrypting assertion");
                    Assertion decryptedAssertion = context.getLocalDecrypter().decrypt(ea);
                    assertionList.add(decryptedAssertion);
                }
                catch (DecryptionException e) {
                    this.log.debug("Decryption of received assertion failed, assertion will be skipped", (Throwable)e);
                }
            }
        }
        Exception lastError = null;
        for (Assertion assertion : assertionList) {
            if (assertion.getAuthnStatements().size() > 0) {
                try {
                    this.verifyAssertion(assertion, request, context);
                    subjectAssertion = assertion;
                    this.log.debug("Validation of authentication statement in assertion {} was successful", (Object)assertion.getID());
                    break;
                }
                catch (Exception e) {
                    this.log.debug("Validation of authentication statement in assertion failed, skipping", (Throwable)e);
                    lastError = e;
                    continue;
                }
            }
            this.log.debug("Assertion {} did not contain any authentication statements, skipping", (Object)assertion.getID());
        }
        if (subjectAssertion == null) {
            throw new SAMLException("Response doesn't have any valid assertion which would pass subject validation", lastError);
        }
        for (Assertion assertion : assertionList) {
            if (assertion != subjectAssertion && !this.isIncludeAllAttributes()) continue;
            for (AttributeStatement attStatement : assertion.getAttributeStatements()) {
                for (Attribute att : attStatement.getAttributes()) {
                    this.log.debug("Including attribute {} from assertion {}", (Object)att.getName(), (Object)assertion.getID());
                    attributes.add(att);
                }
                for (Attribute att : attStatement.getEncryptedAttributes()) {
                    Assert.notNull((Object)context.getLocalDecrypter(), (String)"Can't decrypt Attribute, no decrypter is set in the context");
                    Attribute decryptedAttribute = context.getLocalDecrypter().decrypt((EncryptedAttribute)att);
                    this.log.debug("Including decrypted attribute {} from assertion {}", (Object)decryptedAttribute.getName(), (Object)assertion.getID());
                    attributes.add(decryptedAttribute);
                }
            }
        }
        NameID nameId = (NameID)context.getSubjectNameIdentifier();
        if (nameId == null) {
            throw new SAMLException("NameID element must be present as part of the Subject in the Response message, please enable it in the IDP configuration");
        }
        Serializable additionalData = this.processAdditionalData(context);
        if (this.isReleaseDOM()) {
            subjectAssertion.releaseDOM();
            subjectAssertion.releaseChildrenDOM(true);
        }
        return new SAMLCredential(nameId, subjectAssertion, context.getPeerEntityMetadata().getEntityID(), context.getRelayState(), attributes, context.getLocalEntityId(), additionalData);
    }

    protected Serializable processAdditionalData(SAMLMessageContext context) throws SAMLException {
        return null;
    }

    protected void verifyAssertion(Assertion assertion, AuthnRequest request, SAMLMessageContext context) throws AuthenticationException, SAMLException, SecurityException, ValidationException, DecryptionException {
        if (!SAMLUtil.isDateTimeSkewValid(this.getResponseSkew(), this.getMaxAssertionTime(), assertion.getIssueInstant())) {
            throw new SAMLException("Assertion is too old to be used, value can be customized by setting maxAssertionTime value " + assertion.getIssueInstant());
        }
        this.verifyIssuer(assertion.getIssuer(), context);
        this.verifyAssertionSignature(assertion.getSignature(), context);
        if (assertion.getSubject() == null) {
            throw new SAMLException("Assertion does not contain subject and is discarded");
        }
        this.verifySubject(assertion.getSubject(), request, context);
        if (assertion.getAuthnStatements().size() > 0) {
            this.verifyAssertionConditions(assertion.getConditions(), context, true);
            for (AuthnStatement statement : assertion.getAuthnStatements()) {
                if (request != null) {
                    this.verifyAuthenticationStatement(statement, request.getRequestedAuthnContext(), context);
                    continue;
                }
                this.verifyAuthenticationStatement(statement, null, context);
            }
        } else {
            this.verifyAssertionConditions(assertion.getConditions(), context, false);
        }
    }

    protected void verifySubject(Subject subject, AuthnRequest request, SAMLMessageContext context) throws SAMLException, DecryptionException {
        for (SubjectConfirmation confirmation : subject.getSubjectConfirmations()) {
            NameID nameID;
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(confirmation.getMethod())) continue;
            this.log.debug("Processing Bearer subject confirmation");
            SubjectConfirmationData data = confirmation.getSubjectConfirmationData();
            if (data == null) {
                this.log.debug("Bearer SubjectConfirmation invalidated by missing confirmation data");
                continue;
            }
            if (data.getNotBefore() != null) {
                this.log.debug("Bearer SubjectConfirmation invalidated by not before which is forbidden");
                continue;
            }
            if (data.getNotOnOrAfter() == null) {
                this.log.debug("Bearer SubjectConfirmation invalidated by missing notOnOrAfter");
                continue;
            }
            if (data.getNotOnOrAfter().plusSeconds(this.getResponseSkew()).isBeforeNow()) {
                this.log.debug("Bearer SubjectConfirmation invalidated by notOnOrAfter");
                continue;
            }
            if (request != null) {
                if (data.getInResponseTo() == null) {
                    this.log.debug("Bearer SubjectConfirmation invalidated by missing inResponseTo field");
                    continue;
                }
                if (!data.getInResponseTo().equals(request.getID())) {
                    this.log.debug("Bearer SubjectConfirmation invalidated by invalid in response to");
                    continue;
                }
            }
            if (data.getRecipient() == null) {
                this.log.debug("Bearer SubjectConfirmation invalidated by missing recipient");
                continue;
            }
            try {
                this.verifyEndpoint(context.getLocalEntityEndpoint(), data.getRecipient());
            }
            catch (SAMLException e) {
                this.log.debug("Bearer SubjectConfirmation invalidated by recipient assertion consumer URL, found {}", (Object)data.getRecipient());
                continue;
            }
            if (subject.getEncryptedID() != null) {
                Assert.notNull((Object)context.getLocalDecrypter(), (String)"Can't decrypt NameID, no decrypter is set in the context");
                nameID = (NameID)context.getLocalDecrypter().decrypt(subject.getEncryptedID());
            } else {
                nameID = subject.getNameID();
            }
            context.setSubjectNameIdentifier((SAMLObject)nameID);
            return;
        }
        throw new SAMLException("Assertion invalidated by subject confirmation - can't be confirmed by the bearer method");
    }

    protected void verifyAssertionSignature(Signature signature, SAMLMessageContext context) throws SAMLException, SecurityException, ValidationException {
        SPSSODescriptor roleMetadata = (SPSSODescriptor)context.getLocalEntityRoleMetadata();
        boolean wantSigned = roleMetadata.getWantAssertionsSigned();
        if (signature != null) {
            this.verifySignature(signature, context.getPeerEntityMetadata().getEntityID(), context.getLocalTrustEngine());
        } else if (wantSigned && !context.isInboundSAMLMessageAuthenticated()) {
            throw new SAMLException("Metadata includes wantAssertionSigned, but neither Response nor included Assertion is signed");
        }
    }

    protected void verifyAssertionConditions(Conditions conditions, SAMLMessageContext context, boolean audienceRequired) throws SAMLException {
        if (audienceRequired && (conditions == null || conditions.getAudienceRestrictions().size() == 0)) {
            throw new SAMLException("Assertion invalidated by missing Audience Restriction");
        }
        if (conditions == null) {
            return;
        }
        if (conditions.getNotBefore() != null && conditions.getNotBefore().minusSeconds(this.getResponseSkew()).isAfterNow()) {
            throw new SAMLException("Assertion is not yet valid, invalidated by condition notBefore " + conditions.getNotBefore());
        }
        if (conditions.getNotOnOrAfter() != null && conditions.getNotOnOrAfter().plusSeconds(this.getResponseSkew()).isBeforeNow()) {
            throw new SAMLException("Assertion is no longer valid, invalidated by condition notOnOrAfter " + conditions.getNotOnOrAfter());
        }
        LinkedList<Condition> notUnderstoodConditions = new LinkedList<Condition>();
        for (Condition condition : conditions.getConditions()) {
            QName conditionQName = condition.getElementQName();
            if (conditionQName.equals(AudienceRestriction.DEFAULT_ELEMENT_NAME)) {
                this.verifyAudience(context, conditions.getAudienceRestrictions());
                continue;
            }
            if (conditionQName.equals(OneTimeUse.DEFAULT_ELEMENT_NAME)) {
                throw new SAMLException("System cannot honor OneTimeUse condition of the Assertion for WebSSO");
            }
            if (conditionQName.equals(ProxyRestriction.DEFAULT_ELEMENT_NAME)) {
                ProxyRestriction restriction = (ProxyRestriction)condition;
                this.log.debug("Honoring ProxyRestriction with count {}, system does not issue assertions to 3rd parties", (Object)restriction.getProxyCount());
                continue;
            }
            this.log.debug("Condition {} is not understood", (Object)condition);
            notUnderstoodConditions.add(condition);
        }
        this.verifyConditions(context, notUnderstoodConditions);
    }

    protected void verifyAudience(SAMLMessageContext context, List<AudienceRestriction> audienceRestrictions) throws SAMLException {
        block0: for (AudienceRestriction rest : audienceRestrictions) {
            if (rest.getAudiences().size() == 0) {
                throw new SAMLException("No audit audience specified for the assertion");
            }
            for (Audience aud : rest.getAudiences()) {
                if (!context.getLocalEntityId().equals(aud.getAudienceURI())) continue;
                continue block0;
            }
            throw new SAMLException("Local entity is not the intended audience of the assertion in at least one AudienceRestriction");
        }
    }

    protected void verifyConditions(SAMLMessageContext context, List<Condition> conditions) throws SAMLException {
        if (conditions != null && conditions.size() > 0) {
            throw new SAMLException("Assertion contains conditions which are not understood");
        }
    }

    protected void verifyAuthenticationStatement(AuthnStatement auth, RequestedAuthnContext requestedAuthnContext, SAMLMessageContext context) throws AuthenticationException {
        if (!SAMLUtil.isDateTimeSkewValid(this.getResponseSkew(), this.getMaxAuthenticationAge(), auth.getAuthnInstant())) {
            throw new CredentialsExpiredException("Authentication statement is too old to be used with value " + auth.getAuthnInstant());
        }
        if (auth.getSessionNotOnOrAfter() != null && auth.getSessionNotOnOrAfter().isBeforeNow()) {
            throw new CredentialsExpiredException("Authentication session is not valid on or after " + auth.getSessionNotOnOrAfter());
        }
        this.verifyAuthnContext(requestedAuthnContext, auth.getAuthnContext(), context);
    }

    protected void verifyAuthnContext(RequestedAuthnContext requestedAuthnContext, AuthnContext receivedContext, SAMLMessageContext context) throws InsufficientAuthenticationException {
        this.log.debug("Verifying received AuthnContext {} against requested {}", (Object)receivedContext, (Object)requestedAuthnContext);
        if (requestedAuthnContext != null && AuthnContextComparisonTypeEnumeration.EXACT.equals(requestedAuthnContext.getComparison())) {
            String classRef = null;
            String declRef = null;
            if (receivedContext.getAuthnContextClassRef() != null) {
                classRef = receivedContext.getAuthnContextClassRef().getAuthnContextClassRef();
            }
            if (requestedAuthnContext.getAuthnContextClassRefs() != null) {
                for (AuthnContextClassRef classRefRequested : requestedAuthnContext.getAuthnContextClassRefs()) {
                    if (!classRefRequested.getAuthnContextClassRef().equals(classRef)) continue;
                    this.log.debug("AuthContext matched with value {}", (Object)classRef);
                    return;
                }
            }
            if (receivedContext.getAuthnContextDeclRef() != null) {
                declRef = receivedContext.getAuthnContextDeclRef().getAuthnContextDeclRef();
            }
            if (requestedAuthnContext.getAuthnContextDeclRefs() != null) {
                for (AuthnContextDeclRef declRefRequested : requestedAuthnContext.getAuthnContextDeclRefs()) {
                    if (!declRefRequested.getAuthnContextDeclRef().equals(declRef)) continue;
                    this.log.debug("AuthContext matched with value {}", (Object)declRef);
                    return;
                }
            }
            throw new InsufficientAuthenticationException("Response doesn't contain any of the requested authentication context class or declaration references");
        }
    }

    public long getMaxAuthenticationAge() {
        return this.maxAuthenticationAge;
    }

    public void setMaxAuthenticationAge(long maxAuthenticationAge) {
        this.maxAuthenticationAge = maxAuthenticationAge;
    }

    public boolean isIncludeAllAttributes() {
        return this.includeAllAttributes;
    }

    public void setIncludeAllAttributes(boolean includeAllAttributes) {
        this.includeAllAttributes = includeAllAttributes;
    }

    public boolean isReleaseDOM() {
        return this.releaseDOM;
    }

    public void setReleaseDOM(boolean releaseDOM) {
        this.releaseDOM = releaseDOM;
    }
}

