/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLRuntimeException;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.providers.ExpiringUsernameAuthenticationToken;
import org.springframework.security.saml.SAMLAuthenticationToken;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.log.SAMLLogger;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;
import org.springframework.security.saml.websso.WebSSOProfileConsumer;
import org.springframework.util.Assert;

public class SAMLAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SAMLAuthenticationProvider.class);
    private boolean forcePrincipalAsString = true;
    private boolean excludeCredential = false;
    protected WebSSOProfileConsumer consumer;
    protected WebSSOProfileConsumer hokConsumer;
    protected SAMLLogger samlLogger;
    protected SAMLUserDetailsService userDetails;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        SAMLCredential credential;
        SAMLMessageContext context;
        block10: {
            if (!this.supports(authentication.getClass())) {
                throw new IllegalArgumentException("Only SAMLAuthenticationToken is supported, " + authentication.getClass() + " was attempted");
            }
            SAMLAuthenticationToken token = (SAMLAuthenticationToken)authentication;
            context = token.getCredentials();
            if (context == null) {
                throw new AuthenticationServiceException("SAML message context is not available in the authentication token");
            }
            try {
                if ("urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser".equals(context.getCommunicationProfileId())) {
                    credential = this.consumer.processAuthenticationResponse(context);
                    break block10;
                }
                if ("urn:oasis:names:tc:SAML:2.0:profiles:holder-of-key:SSO:browser".equals(context.getCommunicationProfileId())) {
                    credential = this.hokConsumer.processAuthenticationResponse(context);
                    break block10;
                }
                throw new SAMLException("Unsupported profile encountered in the context " + context.getCommunicationProfileId());
            }
            catch (SAMLRuntimeException e) {
                log.debug("Error validating SAML message", (Throwable)e);
                this.samlLogger.log("AuthNResponse", "FAILURE", context, (Exception)((Object)e));
                throw new AuthenticationServiceException("Error validating SAML message", (Throwable)e);
            }
            catch (SAMLException e) {
                log.debug("Error validating SAML message", (Throwable)e);
                this.samlLogger.log("AuthNResponse", "FAILURE", context, (Exception)((Object)e));
                throw new AuthenticationServiceException("Error validating SAML message", (Throwable)e);
            }
            catch (ValidationException e) {
                log.debug("Error validating signature", (Throwable)e);
                this.samlLogger.log("AuthNResponse", "FAILURE", context, (Exception)((Object)e));
                throw new AuthenticationServiceException("Error validating SAML message signature", (Throwable)e);
            }
            catch (SecurityException e) {
                log.debug("Error validating signature", (Throwable)e);
                this.samlLogger.log("AuthNResponse", "FAILURE", context, (Exception)((Object)e));
                throw new AuthenticationServiceException("Error validating SAML message signature", (Throwable)e);
            }
            catch (DecryptionException e) {
                log.debug("Error decrypting SAML message", (Throwable)e);
                this.samlLogger.log("AuthNResponse", "FAILURE", context, (Exception)((Object)e));
                throw new AuthenticationServiceException("Error decrypting SAML message", (Throwable)e);
            }
        }
        Object userDetails = this.getUserDetails(credential);
        Object principal = this.getPrincipal(credential, userDetails);
        Collection<? extends GrantedAuthority> entitlements = this.getEntitlements(credential, userDetails);
        Date expiration = this.getExpirationDate(credential);
        SAMLCredential authenticationCredential = this.excludeCredential ? null : credential;
        ExpiringUsernameAuthenticationToken result = new ExpiringUsernameAuthenticationToken(expiration, principal, authenticationCredential, entitlements);
        result.setDetails(userDetails);
        this.samlLogger.log("AuthNResponse", "SUCCESS", context, (Authentication)result, null);
        return result;
    }

    protected Object getUserDetails(SAMLCredential credential) {
        if (this.getUserDetails() != null) {
            return this.getUserDetails().loadUserBySAML(credential);
        }
        return null;
    }

    protected Object getPrincipal(SAMLCredential credential, Object userDetail) {
        if (this.isForcePrincipalAsString()) {
            return credential.getNameID().getValue();
        }
        if (userDetail != null) {
            return userDetail;
        }
        return credential.getNameID();
    }

    protected Collection<? extends GrantedAuthority> getEntitlements(SAMLCredential credential, Object userDetail) {
        if (userDetail instanceof UserDetails) {
            ArrayList authorities = new ArrayList();
            authorities.addAll(((UserDetails)userDetail).getAuthorities());
            return authorities;
        }
        return Collections.emptyList();
    }

    protected Date getExpirationDate(SAMLCredential credential) {
        List statementList = credential.getAuthenticationAssertion().getAuthnStatements();
        DateTime expiration = null;
        for (AuthnStatement statement : statementList) {
            DateTime newExpiration = statement.getSessionNotOnOrAfter();
            if (newExpiration == null || expiration != null && !expiration.isAfter((ReadableInstant)newExpiration)) continue;
            expiration = newExpiration;
        }
        return expiration != null ? expiration.toDate() : null;
    }

    public SAMLUserDetailsService getUserDetails() {
        return this.userDetails;
    }

    public boolean supports(Class aClass) {
        return SAMLAuthenticationToken.class.isAssignableFrom(aClass);
    }

    @Autowired(required=false)
    public void setUserDetails(SAMLUserDetailsService userDetails) {
        this.userDetails = userDetails;
    }

    @Autowired
    public void setSamlLogger(SAMLLogger samlLogger) {
        Assert.notNull((Object)samlLogger, (String)"SAMLLogger can't be null");
        this.samlLogger = samlLogger;
    }

    @Autowired
    @Qualifier(value="webSSOprofileConsumer")
    public void setConsumer(WebSSOProfileConsumer consumer) {
        Assert.notNull((Object)consumer, (String)"WebSSO Profile Consumer can't be null");
        this.consumer = consumer;
    }

    @Autowired
    @Qualifier(value="hokWebSSOprofileConsumer")
    public void setHokConsumer(WebSSOProfileConsumer hokConsumer) {
        this.hokConsumer = hokConsumer;
    }

    public boolean isForcePrincipalAsString() {
        return this.forcePrincipalAsString;
    }

    public void setForcePrincipalAsString(boolean forcePrincipalAsString) {
        this.forcePrincipalAsString = forcePrincipalAsString;
    }

    public boolean isExcludeCredential() {
        return this.excludeCredential;
    }

    public void setExcludeCredential(boolean excludeCredential) {
        this.excludeCredential = excludeCredential;
    }

    public void afterPropertiesSet() throws ServletException {
        Assert.notNull((Object)this.consumer, (String)"WebSSO Profile Consumer can't be null");
        Assert.notNull((Object)this.hokConsumer, (String)"WebSSO Profile HoK Consumer can't be null");
        Assert.notNull((Object)this.samlLogger, (String)"SAMLLogger can't be null");
    }
}

