/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.bsm;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.bsm.service.model.Application;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.IpService;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.api.info.Severity;
import org.opennms.netmgt.graph.domain.AbstractDomainVertex;

public final class BusinessServiceVertex
extends AbstractDomainVertex {
    private static final int MAX_LABEL_LENGTH = 27;
    private static final Pattern REDUCTION_KEY_LABEL_PATTERN = Pattern.compile("^.*\\/(.+?):.*:(.+)$");

    public BusinessServiceVertex(GenericVertex genericVertex) {
        super(genericVertex);
        Objects.requireNonNull(Integer.valueOf(this.getLevel()), "getLevel() cannot be null.");
        Objects.requireNonNull(Boolean.valueOf(this.isLeaf()), "isLeaf() cannot be null.");
        Objects.requireNonNull(this.getType(), "getType() cannot be null.");
        Objects.requireNonNull(this.getReductionKeys(), "getReductionKeys() cannot be null.");
        Type type = (Type)((Object)genericVertex.getProperty("type"));
        if (Type.Application == type) {
            Objects.requireNonNull(this.delegate.getProperty("applicationId"), String.format("%s cannot be null", "applicationId"));
        } else if (Type.BusinessService == type) {
            Objects.requireNonNull(this.delegate.getProperty("businessServiceId"), String.format("%s cannot be null", "businessServiceId"));
        } else if (Type.IpService == type) {
            Objects.requireNonNull(this.delegate.getProperty("ipServiceId"), String.format("%s cannot be null", "ipServiceId"));
        } else if (Type.ReductionKey == type) {
            Objects.requireNonNull(this.delegate.getProperty("reductionKeys"), String.format("%s cannot be null", "reductionKeys"));
        } else {
            throw new IllegalArgumentException("Unknown type of BusinessServiceVertex: " + type);
        }
    }

    public int getLevel() {
        return (Integer)this.delegate.getProperty("level");
    }

    public boolean isLeaf() {
        return (Boolean)this.delegate.getProperty("isLeaf");
    }

    public Type getType() {
        return (Type)((Object)this.delegate.getProperty("type"));
    }

    public Set<String> getReductionKeys() {
        return (Set)this.delegate.getProperty("reductionKeys");
    }

    public static final BusinessServiceVertex from(GenericVertex genericVertex) {
        return new BusinessServiceVertex(genericVertex);
    }

    public static BusinessServiceVertexBuilder builder() {
        return new BusinessServiceVertexBuilder();
    }

    protected static String getLabelFromReductionKey(String reductionKey) {
        Matcher m = REDUCTION_KEY_LABEL_PATTERN.matcher(reductionKey);
        String label = m.matches() ? String.format("%s:%s", m.group(1), m.group(2)) : reductionKey;
        if (label.length() > 27) {
            return label.substring(0, 27 - "...".length()) + "...";
        }
        return label;
    }

    static Severity convert(Status status) {
        Objects.requireNonNull(status);
        if (status == Status.INDETERMINATE) {
            return Severity.Unknown;
        }
        return Severity.valueOf((String)status.getLabel());
    }

    static enum Type {
        BusinessService,
        IpService,
        ReductionKey,
        Application;

    }

    static interface Properties {
        public static final String LEVEL = "level";
        public static final String TYPE = "type";
        public static final String IS_LEAF = "isLeaf";
        public static final String REDUCTION_KEYS = "reductionKeys";

        public static interface IpService {
            public static final String id = "ipServiceId";
        }

        public static interface BusinessService {
            public static final String id = "businessServiceId";
        }

        public static interface Application {
            public static final String id = "applicationId";
        }
    }

    public static final class BusinessServiceVertexBuilder
    extends AbstractDomainVertex.AbstractDomainVertexBuilder {
        private BusinessServiceVertexBuilder() {
        }

        public BusinessServiceVertexBuilder reductionKeys(Set<String> reductionKeys) {
            this.property("reductionKeys", ImmutableSet.copyOf(reductionKeys));
            return this;
        }

        public BusinessServiceVertexBuilder type(Type type) {
            this.property("type", (Object)type);
            return this;
        }

        public BusinessServiceVertexBuilder isLeaf(boolean isLeaf) {
            this.property("isLeaf", isLeaf);
            return this;
        }

        public BusinessServiceVertexBuilder level(int level) {
            this.property("level", level);
            return this;
        }

        public BusinessServiceVertexBuilder graphVertex(GraphVertex graphVertex) {
            if (graphVertex.getBusinessService() != null) {
                this.businessService(graphVertex.getBusinessService());
            } else if (graphVertex.getIpService() != null) {
                this.ipService(graphVertex.getIpService());
            } else if (graphVertex.getReductionKey() != null) {
                this.reductionKey(graphVertex.getReductionKey());
            } else if (graphVertex.getApplication() != null) {
                this.application(graphVertex.getApplication());
            } else {
                throw new IllegalArgumentException("Cannot convert GraphVertex to BusinessServiceVertex: " + graphVertex);
            }
            this.level(graphVertex.getLevel());
            this.status(graphVertex.getStatus());
            return this;
        }

        private BusinessServiceVertexBuilder status(Status status) {
            Objects.requireNonNull(status);
            Severity severity = BusinessServiceVertex.convert(status);
            this.property("status", severity);
            return this;
        }

        public BusinessServiceVertexBuilder businessService(BusinessService businessService) {
            this.properties.clear();
            for (Map.Entry eachEntry : businessService.getAttributes().entrySet()) {
                this.property((String)eachEntry.getKey(), eachEntry.getValue());
            }
            this.id(Type.BusinessService + ":" + businessService.getId());
            this.type(Type.BusinessService);
            this.label(businessService.getName());
            this.isLeaf(false);
            this.reductionKeys((Set<String>)ImmutableSet.of());
            this.property("reduceFunction", businessService.getReduceFunction());
            this.property("businessServiceId", businessService.getId());
            return this;
        }

        public BusinessServiceVertexBuilder ipService(IpService ipService) {
            this.properties.clear();
            this.id(Type.IpService + ":" + ipService.getId());
            this.type(Type.IpService);
            this.label(ipService.getServiceName());
            this.isLeaf(true);
            this.reductionKeys(ipService.getReductionKeys());
            this.nodeRef(ipService.getNodeId());
            this.property("ipAddr", ipService.getIpAddress());
            this.property("ipAddress", ipService.getIpAddress());
            this.property("ipServiceId", ipService.getId());
            return this;
        }

        public BusinessServiceVertexBuilder reductionKey(String reductionKey) {
            this.properties.clear();
            this.id(Type.ReductionKey + ":" + reductionKey);
            this.type(Type.ReductionKey);
            this.label(BusinessServiceVertex.getLabelFromReductionKey(reductionKey));
            this.isLeaf(true);
            this.reductionKeys((Set<String>)ImmutableSet.of((Object)reductionKey));
            return this;
        }

        public BusinessServiceVertexBuilder application(Application application) {
            this.properties.clear();
            this.id(Type.Application + ":" + application.getId());
            this.type(Type.Application);
            this.label(application.getApplicationName());
            this.reductionKeys(application.getReductionKeys());
            this.isLeaf(true);
            this.property("applicationId", application.getId());
            return this;
        }

        public BusinessServiceVertex build() {
            return new BusinessServiceVertex(((GenericVertex.GenericVertexBuilder)((GenericVertex.GenericVertexBuilder)GenericVertex.builder().namespace("bsm")).properties(this.properties)).build());
        }
    }
}

