/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractSplitPanel;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.v7.ui.Tree;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.opennms.features.vaadin.jmxconfiggenerator.JmxConfigGeneratorUI;
import org.opennms.features.vaadin.jmxconfiggenerator.data.JmxCollectionCloner;
import org.opennms.features.vaadin.jmxconfiggenerator.data.UiModel;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.ButtonPanel;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UiState;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansContentPanel;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansController;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansTree;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.SelectionManager;
import org.opennms.netmgt.config.collectd.jmx.Attrib;
import org.opennms.netmgt.config.collectd.jmx.CompAttrib;
import org.opennms.netmgt.config.collectd.jmx.CompMember;
import org.opennms.netmgt.config.collectd.jmx.JmxCollection;
import org.opennms.netmgt.config.collectd.jmx.JmxDatacollectionConfig;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.opennms.netmgt.vaadin.core.ConfirmationDialog;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class MBeansView
extends VerticalLayout
implements Button.ClickListener,
View {
    private final MBeansController controller;
    private UiModel model;
    private final JmxConfigGeneratorUI app;
    private final MBeansTree mbeansTree;
    private final MBeansContentPanel mbeansContentPanel;
    private final ButtonPanel buttonPanel = new ButtonPanel(this);

    public MBeansView(JmxConfigGeneratorUI app) {
        this.app = app;
        this.controller = new MBeansController();
        this.mbeansContentPanel = new MBeansContentPanel(this.controller);
        this.mbeansTree = new MBeansTree(this.controller);
        this.controller.registerSelectionChangedListener(this.mbeansContentPanel);
        this.controller.setMbeansContentPanel(this.mbeansContentPanel);
        this.controller.setMbeansTree(this.mbeansTree);
        AbstractSplitPanel mainPanel = this.initMainPanel(this.mbeansTree, (Component)this.mbeansContentPanel);
        this.addComponent((Component)mainPanel);
        this.addComponent((Component)this.buttonPanel);
        this.setExpandRatio((Component)mainPanel, 1.0f);
        this.setSizeFull();
    }

    public void buttonClick(final Button.ClickEvent event) {
        if (event.getButton().equals((Object)this.buttonPanel.getPrevious())) {
            this.app.updateView(UiState.ServiceConfigurationView);
        }
        if (event.getButton().equals((Object)this.buttonPanel.getNext())) {
            if (this.mbeansContentPanel.isDirty()) {
                new ConfirmationDialog().withOkAction(new ConfirmationDialog.Action(){

                    public void execute(ConfirmationDialog window) {
                        MBeansView.this.mbeansContentPanel.discard();
                        MBeansView.this.buttonClick(event);
                    }
                }).withOkLabel("yes").withCancelLabel("no").withCaption("Validation errors").withDescription("The current view contains validation errors.<br/>The values cannot be saved.<br/>If you continue, they are lost.<br/><br/>Do you want to move to the next page?").open();
                return;
            }
            if (!this.isValid()) {
                UIHelper.showValidationError((String)"There are errors on this view. Please fix them first");
                return;
            }
            this.model.setJmxDataCollectionAccordingToSelection(MBeansView.createJmxDataCollectionAccordingToSelection(this.model, this.controller));
            this.app.updateView(UiState.ResultConfigGeneration);
        }
    }

    private AbstractSplitPanel initMainPanel(Tree first, Component second) {
        HorizontalSplitPanel splitPanel = new HorizontalSplitPanel();
        splitPanel.setSizeFull();
        splitPanel.setLocked(false);
        splitPanel.setSplitPosition(25.0f, Sizeable.Unit.PERCENTAGE);
        splitPanel.setFirstComponent((Component)first);
        splitPanel.setSecondComponent(second);
        splitPanel.setCaption(first.getCaption());
        return splitPanel;
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        if (this.app.getUiModel() != this.model) {
            UiModel newModel;
            this.model = newModel = this.app.getUiModel();
            this.controller.updateDataSource(this.model);
        }
    }

    private boolean isValid() {
        return this.controller.isValid();
    }

    private static JmxDatacollectionConfig createJmxDataCollectionAccordingToSelection(UiModel uiModel, SelectionManager selectionManager) {
        JmxDatacollectionConfig clone = JmxCollectionCloner.clone(uiModel.getRawModel());
        List exportBeans = ((JmxCollection)clone.getJmxCollectionList().get(0)).getMbeans();
        exportBeans.clear();
        Collection<Mbean> selectedMbeans = selectionManager.getSelectedMbeans();
        for (Mbean mbean : selectedMbeans) {
            Mbean exportBean = JmxCollectionCloner.clone(mbean);
            exportBean.clearAttribs();
            for (Attrib att : selectionManager.getSelectedAttributes(mbean)) {
                exportBean.addAttrib(JmxCollectionCloner.clone(att));
            }
            if (!exportBean.getAttribList().isEmpty()) {
                exportBeans.add(exportBean);
            }
            exportBean.clearCompAttribs();
            for (CompAttrib compAtt : selectionManager.getSelectedCompositeAttributes(mbean)) {
                CompAttrib cloneCompAtt = JmxCollectionCloner.clone(compAtt);
                cloneCompAtt.clearCompMembers();
                for (CompMember compMember : selectionManager.getSelectedCompositeMembers(compAtt)) {
                    cloneCompAtt.addCompMember(JmxCollectionCloner.clone(compMember));
                }
                if (cloneCompAtt.getCompMemberList().isEmpty()) continue;
                exportBean.addCompAttrib(cloneCompAtt);
            }
        }
        MBeansView.sort(exportBeans);
        ((JmxCollection)clone.getJmxCollectionList().get(0)).setName(uiModel.getServiceName());
        return clone;
    }

    private static void sort(List<Mbean> input) {
        Collections.sort(input, new Comparator<Mbean>(){

            @Override
            public int compare(Mbean o1, Mbean o2) {
                return o1.getObjectname().compareTo(o2.getObjectname());
            }
        });
        for (Mbean eachMbean : input) {
            ArrayList attribs = new ArrayList(eachMbean.getAttribList());
            Collections.sort(attribs);
            eachMbean.setAttribCollection(attribs);
            ArrayList compAttribs = new ArrayList(eachMbean.getCompAttribList());
            Collections.sort(compAttribs);
            eachMbean.setCompAttribCollection(compAttribs);
            for (CompAttrib eachCompAttrib : eachMbean.getCompAttribList()) {
                ArrayList compMembers = new ArrayList(eachCompAttrib.getCompMemberList());
                Collections.sort(compMembers);
                eachCompAttrib.setCompMemberList(compMembers);
            }
        }
    }
}

