/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.drools;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.alarmd.api.Destination;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.northbounder.drools.Global;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@XmlRootElement(name="engine")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DroolsEngine
implements Destination {
    private static final long serialVersionUID = 6351398964945801319L;
    private static final Logger LOG = LoggerFactory.getLogger(DroolsEngine.class);
    @XmlElement(name="name", required=true)
    private String m_name;
    @XmlElement(name="filter", required=false)
    private String m_filter;
    @XmlElement(name="assertBehaviour", required=false, defaultValue="identity")
    private String m_assertBehaviour;
    @XmlElement(name="global", required=false)
    private List<Global> m_globals = new ArrayList<Global>();
    @XmlElement(name="ruleFile", required=true)
    private List<String> m_ruleFiles = new ArrayList<String>();
    @XmlElement(name="appContext", required=false)
    private String m_appContext;

    public boolean isFirstOccurrenceOnly() {
        return false;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getFilter() {
        return this.m_filter;
    }

    public void setFilter(String filter) {
        this.m_filter = filter;
    }

    public String getAssertBehaviour() {
        return this.m_assertBehaviour == null ? "identity" : this.m_assertBehaviour;
    }

    public void setAssertBehaviour(String assertBehaviour) {
        this.m_assertBehaviour = assertBehaviour;
    }

    public String getAppContext() {
        return this.m_appContext;
    }

    public void setAppContext(String appContext) {
        this.m_appContext = appContext;
    }

    public List<Global> getGlobals() {
        return this.m_globals;
    }

    public void setGlobals(List<Global> globals) {
        this.m_globals = globals;
    }

    public List<String> getRuleFiles() {
        return this.m_ruleFiles;
    }

    public void setRuleFiles(List<String> ruleFiles) {
        this.m_ruleFiles = ruleFiles;
    }

    public boolean accepts(NorthboundAlarm alarm) {
        if (this.getFilter() != null) {
            StandardEvaluationContext context = new StandardEvaluationContext((Object)alarm);
            SpelExpressionParser parser = new SpelExpressionParser();
            Expression exp = parser.parseExpression(this.m_filter);
            boolean passed = false;
            try {
                passed = (Boolean)exp.getValue((EvaluationContext)context, Boolean.class);
            }
            catch (Exception e) {
                LOG.warn("accepts: can't evaluate expression {} for alarm {} because: {}", new Object[]{this.getFilter(), alarm.getUei(), e.getMessage()});
            }
            LOG.debug("accepts: checking {} ? {}", (Object)this.m_filter, (Object)passed);
            return passed;
        }
        return true;
    }
}

